#include "LookupTable.h"
#include "sfh_mbed.h"

#include <iostream>
#define LOOKUP_TABLE_SIZE 30000

LookupTable::LookupTable(void){
    //uint32_t * lookupTable = new int[INITIAL_LOOKUP_TABLE_SIZE];   
    LookupTableStruct = new (nothrow) pair<BLEProtocol::AddressBytes_t, unsigned char *> * [LOOKUP_TABLE_SIZE];

    if(this->LookupTableStruct == NULL){
        printf("Exception ignored, uncomment 'nothrow' for more efficient code\n\n"); 
    }

}

void LookupTable::clearLookupTable(void){
    for(uint32_t i = 0; i < LOOKUP_TABLE_SIZE; i++){
      delete LookupTableStruct[i];
    }
    delete [] LookupTableStruct; 
}

LookupTable::~LookupTable(void){
    clearLookupTable(); 
}


int LookupTable::insertValue(BLEProtocol::AddressBytes_t scanned_ble_address, unsigned char * encryptedCounter){
    
    if(scanned_ble_address == NULL || encryptedCounter == NULL)
        return -1; //Error

   // map<const char * data, 
     uint32_t hasehdBLEAddress = hash((const char *) scanned_ble_address, 6);
    //uint32_t hashedCounter = hash(encryptedCounter,sizeof(encryptedCounter));

    //map<BLEProtocol::AddressBytes_t, unsigned char *> indirectMap;
    uint32_t index = hasehdBLEAddress % LOOKUP_TABLE_SIZE;
    pair<BLEProtocol::AddressBytes_t, unsigned char *> tableValue;// = make_pair (scanned_ble_address,encryptedCounter); // (scanned_ble_address, encryptedCounter); 
    //tableValue = make_pair(scanned_ble_address,encryptedCounter);
    tableValue = pair<BLEProtocol::AddressBytes_t, unsigned char *>(scanned_ble_address,encryptedCounter); 
    LookupTableStruct[index] = &tableValue; 

    return 0; //Success
}