#include "mbed.h"
#include "VL53L0X.h"

#define range1_addr (0x56)
#define range2_addr (0x60)
#define range1_XSHUT   p15
#define range2_XSHUT   p16
#define VL53L0_I2C_SDA   p30 
#define VL53L0_I2C_SCL   p7  
 
Serial pc(USBTX, USBRX);
static DevI2C devI2c(VL53L0_I2C_SDA, VL53L0_I2C_SCL); 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
 
int main()
{   
    /*Contruct the sensors*/ 
    static DigitalOut shutdown1_pin(range1_XSHUT);
    static VL53L0X range1(&devI2c, &shutdown1_pin, NC);
    static DigitalOut shutdown2_pin(range2_XSHUT);
    static VL53L0X range2(&devI2c, &shutdown2_pin, NC);
    /*Initial all sensors*/   
    range1.init_sensor(range1_addr);
    range2.init_sensor(range2_addr);

    /*Get datas*/
    uint32_t distance1;
    uint32_t distance2;
    int status1;
    int status2;
  
    while(1){
        status1 = range1.get_distance(&distance1);
        status2 = range2.get_distance(&distance2);
        if (status1 == VL53L0X_ERROR_NONE) {
//            printf("Range1 [mm]:            %6ld\r\n", distance1);
            if (distance1 > 40 && distance1 < 2200) {
                led1 = 0;
            }
            else {
                led1 = 1;
            }
        } else {
//            printf("Range1 [mm]:                --\r\n");
            led1 = 1;
        }
        if (status2 == VL53L0X_ERROR_NONE) {
//            printf("Range2 [mm]:            %6ld\r\n", distance2);
        if (distance2 > 40 && distance2 < 2200) {
            led2 = 0;
        }
        } else {
//            printf("Range2 [mm]:                --\r\n");
            led2 = 1;
        }
        wait(0.2);                 
    }
 
}
 
