#include "mbed.h"
#include "ble/BLE.h"
#include "mbed.h"
#include "VL53L0X.h"

#define range1_addr (0x56)
#define range2_addr (0x60)
#define range1_XSHUT   p15
#define range2_XSHUT   p16
#define VL53L0_I2C_SDA   p30 
#define VL53L0_I2C_SCL   p7  
 
Serial pc(USBTX, USBRX);
static DevI2C devI2c(VL53L0_I2C_SDA, VL53L0_I2C_SCL); 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led(LED3, 1);
uint16_t customServiceUUID  = 0xA000;
uint16_t readCharUUID       = 0xA001;
uint16_t writeCharUUID      = 0xA002;

static DigitalOut shutdown1_pin(range1_XSHUT);
static VL53L0X range1(&devI2c, &shutdown1_pin, NC);
static DigitalOut shutdown2_pin(range2_XSHUT);
static VL53L0X range2(&devI2c, &shutdown2_pin, NC);

uint32_t distance1;
uint32_t distance2;
int status1;
int status2;

const static char     DEVICE_NAME[]        = "OCCUPY-CRICHTON-ST"; // change this
static const uint16_t uuid16_list[]        = {0xFFFF}; //Custom UUID, FFFF is reserved for development

/* Set Up custom Characteristics */
static uint8_t readValue[10] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(readValue)> readChar(readCharUUID, readValue);

static uint8_t writeValue[10] = {0};
WriteOnlyArrayGattCharacteristic<uint8_t, sizeof(writeValue)> writeChar(writeCharUUID, writeValue);

/* Set up custom service */
GattCharacteristic *characteristics[] = {&readChar, &writeChar};
GattService        customService(customServiceUUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *)
{
    BLE::Instance(BLE::DEFAULT_INSTANCE).gap().startAdvertising();
}

void writeCharCallback(const GattWriteCallbackParams *params)
{
    /* Check to see what characteristic was written, by handle */
    if(params->handle == writeChar.getValueHandle()) {
        /* toggle LED if only 1 byte is written */
        if(params->len == 1) {
            led = params->data[0];
            (params->data[0] == 0x00) ? printf("led on\n\r") : printf("led off\n\r"); // print led toggle
        }
        /* Print the data if more than 1 byte is written */
        else {
            printf("Data received: length = %d, data = 0x",params->len);
            for(int x=0; x < params->len; x++) {
                printf("%x", params->data[x]);
            }
            printf("\n\r");
        }
        /* Update the readChar with the value of writeChar */
        BLE::Instance(BLE::DEFAULT_INSTANCE).gattServer().write(readChar.getValueHandle(), params->data, params->len);
    }
}

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &ble          = params->ble;
    ble_error_t error = params->error;
    
    if (error != BLE_ERROR_NONE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(writeCharCallback);

    /* Setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE); // BLE only, no classic BT
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED); // advertising type
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME)); // add name
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list)); // UUID's broadcast in advertising packet
    ble.gap().setAdvertisingInterval(100); // 100ms.

    /* Add our custom service */
    ble.addService(customService);

    /* Start advertising */
    ble.gap().startAdvertising();
}
void wakeup_event_cb() {
    led != led;
    
    status1 = range1.get_distance(&distance1);
    status2 = range2.get_distance(&distance2);
    if (status1 == VL53L0X_ERROR_NONE) {
        printf("Range1 [mm]:            %6ld\r\n", distance1);
        if (distance1 > 40 && distance1 < 2200) {
            led1 = 0;
        }
        else {
            led1 = 1;
        }
    } else {
        printf("Range1 [mm]:                --\r\n");
        led1 = 1;
    }
    if (status2 == VL53L0X_ERROR_NONE) {
        printf("Range2 [mm]:            %6ld\r\n", distance2);
    if (distance2 > 40 && distance2 < 2200) {
        led2 = 0;
    }
    } else {
        printf("Range2 [mm]:                --\r\n");
        led2 = 1;
    }
//  wait(0.2);    
}

int main(void)
{
    range1.init_sensor(range1_addr);
    range2.init_sensor(range2_addr);
    
    printf("\n\r********* Starting Main Loop *********\n\r");
  
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    ble.init(bleInitComplete);
    
    Ticker ticker;
    
    ticker.attach(wakeup_event_cb, 0.3);
    
    while (ble.hasInitialized()) {
        ble.waitForEvent(); 
    }
}