#include "mbed.h"
#include "RAPIDMP3.h"


RAPIDMP3 rmp3(D8, D2);    // Tx, Rx
Serial pc(USBTX, USBRX);

int main() {
    
    pc.puts("RAPID_MP3_V1 module demonstration\r\n");
    
    // After powering up, wait atleast a second before sending commands
    wait(1.0);  
    
    while (1) {
        
        // Play track till its end
        rmp3.playFile("track1.mp3");
        rmp3.waitEndOfPlay();                    
                
        // Play track for a specified duration
        rmp3.playFile("track2.mp3");
        wait(20.0);
        rmp3.stop();        
        wait(5.0);        
        
        // Play, pause and resume a track
        rmp3.playFile("track3.mp3");
        wait(10.0);
        rmp3.playPause();
        wait(5.0);        
        rmp3.playResume();        
        wait(5.0);
        
        // Set volume level to 2
        rmp3.volumeSet(2);  // 0 is max, 9 is mute
        wait(5.0);
        
        // Increase volume one level
        rmp3.volumeInc();
        wait(5.0);
        
        // Decrease volume one level
        rmp3.volumeDec();
        wait(5.0);
                
        // Get current volume level and send to PC
        uint8_t volume = rmp3.volumeGet();
        pc.printf("current volume level = %d\r\n", volume);
        wait(5.0);
        
        // Read playback status
        uint8_t playStatus = rmp3.getPlaybackStatus();
        if (playStatus == RMP3_BUSY) {
            pc.puts("Device is busy\r\n");            
            // Stop current playback
            rmp3.stop();  
        }        
        pc.puts("Device is free\r\n");        
        wait(5.0);
        
        // Record audio as .wav file for a specified duration
        rmp3.recordFile("rec_001.wav");
        wait(20.0);
        rmp3.stop();        
                
        // Play the recorded audio till its end
        rmp3.playFile("rec_001.wav");
        rmp3.waitEndOfPlay();
        
        wait(5.0);      
        
        // loop again.
    }
}