#include "mbed.h"
#include "DHT.h"

DHT sensor(D4, DHT11);
Timeout response;

DigitalOut green(LED_GREEN);
DigitalOut red(LED_RED);
DigitalIn  sw2(SW2);
Serial pc(USBTX, USBRX );

Serial blue(PTC15, PTC14); //tx, rx

int main()
{
    int error = 0;
    float h = 0.0f, k = 0.0f, dpf = 0.0f;
    int c; 
    int f;
    int dp;
    char send = 'Z';
    char hold = 'b';
    char correct = 'C';
    int rangeFeet;
     
    
    pc.baud(9600);
    blue.baud(9600);
    
    printf("Slave connecting to the master\n");
    
    
      //------------------------Sensor Start-------------------------------------
    
    
    while (send!='R') {
        wait(0.5f);
        error = sensor.readData();
        if (0 == error) 
        {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            
            printf("\n Temperature in Kelvin: %4.2f, Celcius: %i, Farenheit %i\n\r", k, c, f);
            printf("\n Humidity is %4.2f, Dewpoint: %i, Dewpoint fast: %4.2f\n\r", h, dp, dpf);
        } 
        else 
        {
        //    printf("Error: %d\n\r", error);
        }
       
       
       //-----------------------Sensor End--------------------------------------
       //-----------------------Transmit Begin----------------------------------
       
        if(blue.readable())
        {
            char word = f + '0'; 
            blue.putc(word); 
            
            wait(0.5f);
            
            word = dp + '0';
            blue.putc(word);
        }
        
        //----------------------Transmit End------------------------------------
        
        wait(0.5f); // wait a small period of time        
        green = !green; // toggle a led
        
    }
}

