#include "mbed.h"
#include "HCSR04.h"
#define PIN_TRIGGER    D0
#define PIN_ECHO       D1

Timeout response;

DigitalOut green(LED_GREEN);
DigitalOut red(LED_RED);
DigitalIn  sw2(SW2);
DigitalIn  motion(D7);
Serial pc(USBTX, USBRX );

Serial blue(PTC15, PTC14); //tx, rx


int main()
{
    HCSR04 rangeFinder( PIN_TRIGGER, PIN_ECHO );
    char send = 'Z';
    int rangeFeet;
    float range; 
    
    pc.baud(9600);
    blue.baud(9600);
    
    printf("Slave connecting to the master\n");
    
    //--------------------------------------------------------------------------
  
    while (true) {
                rangeFinder.startMeas();
                wait(0.5f);
                if ( rangeFinder.getMeas(range) == RANGE_MEAS_VALID )
                {
                     
                   // printf("pre mod range = %f \n\r", range);
                    range = (range * 100); 
                   // printf("post mod range = %f \n\r", range);
                    rangeFeet = range; 
                   // printf("rangeFeet = %i \n\r", rangeFeet);
                }   
         
      
    //--------------------------------------------------------------------------
      
      
        if(blue.readable())//Determine if there is a character available to read. 
        {
            if(rangeFeet > 2900)
            {
            rangeFeet = 0;     
            }
            char word = (rangeFeet) + '0';
            //printf("\n word = %c \n\r", word);
            blue.putc(word);
        }
        
        
    //--------------------------------------------------------------------------
        wait(0.5f); // wait a small period of time        
        green = !green; // toggle a led
        
    }
}