#include "mbed.h"
#include "MorseCharacter.h"

int main() {
    DigitalOut morseOut(LED1);
    PwmOut speaker(p21);

    speaker.period(1.0/(440.0*4)); 
    char* output = "This is a pretty long string being output through MOTHERFUCKING MORSE CODE";
    char outputLength = strlen(output);
    char strpos = 0;
    const float period13WPM = 0.092f;
    float timeUnit = period13WPM/2;
    while(strpos < outputLength) { // for each character in string
        MorseCharacter morseChar(output[strpos]);
        char morseParts = morseChar.getNumberOfParts();
        if(morseParts > 0) {
            for(int i=0; i < morseParts; i++) {
                morseOut = 1;
                speaker = 0.5;
                // wait 3 time units for a dah, 1 time unit for a dit
                wait((morseChar.getPart(i) == morseChar.DIT ? 1.0 : 3.0) * timeUnit);
                morseOut = 0;
                speaker = 0;
                wait(1*timeUnit); // time between dits/dahs is 1 time unit. 
            }
            wait(timeUnit*2); // time between letters is 3 time units.
                              // there should already be 1 time unit after the
                              // last dit/dah.
        } else {
            wait(timeUnit * 4); // time between words is 7 time units.
                                // there should be 3 time units after the last
                                // character was sent.
        }
        strpos++;
        if(strpos == outputLength) { // if message is over,
            wait(1.0f); // wait 1 seconds
            strpos = 0; // start over;
        }
    }
}
