/**
 * Packed Morse Character
 *
 * Morse Code Sequences have been packed into one byte.
 *
 * Bits 7-5: Octal containing the number of parts (dits or dahs)
 *           If the octal is zero, the morse character is a space.
 *
 * Bits 4:0  Each morse part: 0: DIT
 *                            1: DAH
 * @author  Michael Vartan
 */
class MorseCharacter {
    char mSequence;
    
    const static char numbers[];
    const static char letters[];
    
    public:
        const static char DIT = 0;
        const static char DAH = 1;
        
        MorseCharacter(char character);
        char getPart(int partNumber) const;
        
         /**
         * Get Number of Morse Parts. 
         * 
         * Get bits 7-5 for the number of dits/dahs in the morse sequence.
         */
        inline char getNumberOfParts() const {
            return this->mSequence >> 5;
        }
};
