#include "MorseCharacter.h"

MorseCharacter::MorseCharacter(char character) {
    if(character >= '0' && character <= '9')
      mSequence = numbers[character - '0'];
    else if(character >= 'a' && character <= 'z')
      mSequence = letters[character - 'a'];
    else if(character >= 'A' && character <= 'Z')
      mSequence = letters[character - 'A'];
    else
      mSequence = 0x00;   
}

/**
 * Get Morse Part
 * 
 * Returns the nth dit/dah in the morse sequence.
 */
char MorseCharacter::getPart(int partNumber) const {
    char length = this->getNumberOfParts();
    if(partNumber >= length) {
        return 0x00; // error or space
    } else {
        return this->mSequence & (0x01 << (4-partNumber)); // 1:dash, 0:dit
    }
}

const char MorseCharacter::numbers[] = {
    0xBF, // 0
    0xAF, // 1
    0xA7, // 2
    0xA3, // 3
    0xA1, // 4
    0xA0, // 5
    0xB0, // 6
    0xB8, // 7
    0xBC, // 8
    0xBE  // 9    
};
const char MorseCharacter::letters[]  = {
    0x48, // A
    0x90, // B
    0x94, // C
    0x70, // D
    0x20, // E
    0x84, // F
    0x78, // G
    0x80, // H
    0x40, // I
    0x8E, // J
    0x74, // K
    0x88, // L
    0x58, // M
    0x50, // N
    0x7C, // O
    0x8C, // P
    0x9A, // Q
    0x68, // R
    0x60, // S
    0x30, // T
    0x64, // U
    0x82, // V
    0x6C, // W
    0x92, // X
    0x96, // Y
    0x98  // Z
};
