#include "mbed.h"
#include "SSD1327.h"

/// 96x96 pixel SSD1327 SeeedStudio 1.12" OLED display
/// http://www.displayfuture.com/Display/datasheet/controller/SSD1327.pdf
/// based on https://github.com/blitz/mbed-arch-pro

// font info
int font_w;
int font_h;
int font_bpc; //bytes per char width
uint8_t *font_s;

unsigned char currR, currC;

unsigned char grayH;
unsigned char grayL;


bool SSD1327::send(char mode, const char data[], size_t len)
    {
        for (size_t c = 0; c < len; c++) {
            const char snd[2]= { mode, data[c] };
            if (i2c.write(address, snd, sizeof(snd)) != 0)
                return false;
        }

        return true;
    }

/*bool SSD1327::sendf(char mode, char data[], size_t len)
    {
        for (size_t c = 0; c < len; c++) {
            const char snd[2]= { mode, data[c] };
            if (i2c.write(address, snd, sizeof(snd)) != 0)
                return false;
        }

        return true;
    } */

bool SSD1327::sendx(char mode, char data[], size_t len)
    {
        char snd[52];
        snd[0]=mode;
        for (char c=0;c<len;c++) snd[c+1]=data[c];
        if (i2c.write(address, snd, len+1) != 0)
                return false;
        return true;
    }

void SSD1327::tribyte_cmd(uint8_t a, uint8_t b, uint8_t c)
    {
        char data[] = { a, b, c };
        send(cmd_mode, data, sizeof(data));

    }

void SSD1327::set_column_address(uint8_t start, uint8_t end)
    {
        tribyte_cmd(0x15, start, end);
    }

void SSD1327::set_row_address(uint8_t start, uint8_t end)
    {
        tribyte_cmd(0x75, start, end);
    }
    
void SSD1327::set_gray_level(unsigned char level)
    {
        grayL =  level & 0x0F;
        grayH =  grayL<<4;
    }
    
void SSD1327::set_text_rc(unsigned char row, unsigned char column)
{
  currR=row;
  currC=column;
  set_column_address(8+column*font_w/2,8+column*font_w/2+font_w/2-1);
  set_row_address(0x00+(row*font_h),0x00+(row*font_h+(font_h-1)));
}    

void SSD1327::set_rc(unsigned char row, unsigned char column)
{
  if (row>PIXELS) row=PIXELS;
  if (column>PIXELS) column=PIXELS;
  currR=row;
  currC=column/2;
  set_column_address(8+column/2,8+column/2+font_w/2-1);
  set_row_address(row,row+(font_h-1));
}    

void SSD1327::putc(unsigned char C)
{
  uint8_t line;
  uint8_t *pchar;
  char cc=0;
   char out[50];

    if(C < 32 || C > 127) //Ignore non-printable ASCII characters. This can be modified for multilingual font.
    {
        C=' '; //Space
    }

    pchar=font_s+((C-32)*font_h*font_bpc);

    for (char i = 0; i < font_h; i++) {
      char outcc=0;
      for (char j=0; j<font_bpc; j++) {
          line=pchar[cc++];
          for (char k=0; k<4;k++) {
            char c=0x00;
            char bit1=line & 0x80; line<<=1;
            char bit2=line & 0x80; line<<=1;
            c|=(bit1)?grayH:0x00;
            c|=(bit2)?grayL:0x00;
            out[outcc++]=c;
          }
      }
      sendx(data_mode,out,font_bpc*4);
    }
    set_text_rc(currR,currC+1);
}

void SSD1327::puts(const char *str)
{
    unsigned char i=0;
    while(str[i])
    {
        putc(str[i]);
        i++;
    }
}

void SSD1327::set_font(const uint8_t *Font, int width, int height) {
  font_s= (uint8_t *) Font;
  font_h=height;
  font_w=width;
  font_bpc=width/8;
}



void SSD1327::clear()
    {
        char empty[48]={0};    
        set_column_address(8, 8 + PIXELS/2 - 1);
        set_row_address   (0, PIXELS - 1);
        for (char j=0;j<96;j++) sendx(data_mode, empty, sizeof(empty));
    }

SSD1327::SSD1327(I2C &i2c)
        : i2c(i2c)
    {
        // Init gray level for text. Default:Brightest White
        grayH= 0xF0;
        grayL= 0x0F;

        static const char init[] = { 0xFD, 0x12, 0xAE, 0xA8, 0x5F, 0xA1,
                                     0x00, 0xA2, 0x60, 0xA0, 0x46, 0xAB,
                                     0x01, 0x81, 0x53, 0xB1, 0x51, 0xB3,
                                     0x01, 0xB9, 0xBC, 0x08, 0xBE, 0x07,
                                     0xB6, 0x01, 0xD5, 0x62, 0xA4, 0x2E,
                                     0xAF };

        if (not send(cmd_mode, init, sizeof(init))) {
//            pc.printf("SSD1327 init failed.\n");
        }

        wait_ms(100);

        static const char init2[] = { 0xA0, 0x42,
                                      0x15, 0x08, 0x37, 0x75, 0x00, 0x5f  };

        if (not send(cmd_mode, init2, sizeof(init2))) {
//            pc.printf("SSD1327 init2 failed.\n");
        }
//        pc.printf("SSD1327 initialized.\n");
        clear();
    }

// EOF
