/*
    Maple Mini (STM32F103RB) peripherals tests
    by Mark Peter Vargha
*/

#include "MapleMini.h"
#include "mbed.h"
#include "Adafruit_ADS1015.h"

DigitalOut          boardLed(LED1);
Serial              serial(PA_2, PA_3);
I2C                 i2c(I2C_SDA , I2C_SCL);
Adafruit_ADS1115    ads(&i2c);
Ticker              oneSecondTicker;

void readAds()
{
    serial.printf("External analog in\r\n");
    for (int i = 0; i < 4; i++)
    {
        int16_t adv = ads.readADC_SingleEnded(i);
        serial.printf("ADC%d=%+06d\r\n", i, adv);
    }
    serial.printf("\r\n");
}

void inEverySecond()
{
    readAds();
}

int main()
{
    confSysClock();
    serial.baud(115200);
    ads.setGain(GAIN_ONE);
    oneSecondTicker.attach(&inEverySecond, 1.0);
    serial.printf("Maple peripherals tests.\r\n");
    
    while(1)
    {
        
    }
}
