#include "mbed.h"
#include "FastPWM.h"
#include <algorithm>

#define ddsstart    SYNC2 = 1;wait_us(10);SYNC2 = 0;wait_us(10)
#define ddsstop     SYNC2 = 1;wait_us(10)
#define ddsreset    DDS.write(0x21C0)
#define sinsoft     DDS.write(0x2000)
#define trisoft     DDS.write(0x2002)
#define tripin      DDS.write(0x2202)
#define ddsoff      DDS.write(0x2048)
#define dacstart    SYNC1 = 1;wait_us(10);SYNC1 = 0;wait_us(10)
#define dacstop     SYNC1 = 1;wait_us(10)
#define mclkstart   mclk.period_us(0.1);mclk.pulsewidth_us(0.05);
#define mclkstop    mclk = 0.0;
#define i2g         IE = 0;emux();IG = 0; II = 0;igmux();imux();
 
//основные пины
Serial serial(USBTX,USBRX);
FastPWM mclk(PA_15);
PwmOut sq(PB_7);
SPI DDS(PC_12, NC, PC_10);
SPI DAC(PC_12, NC, PC_10);
DigitalOut SYNC1(PC_11);//amp dac
DigitalOut SYNC2(PD_2);//dds
// мультиплекс, ЦАП, кнопко

AnalogIn analog_value(PC_4);
DigitalIn button(PA_13); // проверка нажатой кнопки пауза
DigitalIn test_button(USER_BUTTON);

DigitalOut *P0,*P1,*P2,*P3;//Указатели на пины функции mux

//пины управления мультиплексором выбора пояса
DigitalOut IEN(PC_8);
DigitalOut IE0(PB_1);
DigitalOut IE1(PB_15);
DigitalOut IE2(PB_14);
DigitalOut IE3(PB_13);

//пины управления мультиплексорами генератора
DigitalOut II0(PA_0);
DigitalOut II1(PA_1);
DigitalOut II2(PA_4);
DigitalOut II3(PB_0);

//пины управления мультиплексорами земли
DigitalOut IG0(PA_5);
DigitalOut IG1(PA_6);
DigitalOut IG2(PA_7);
DigitalOut IG3(PB_6);

//пины управления мультиплексорами 1 дифф канала 
DigitalOut DI10(PC_7);
DigitalOut DI11(PA_9);
DigitalOut DI12(PA_8);
DigitalOut DI13(PB_10);

//пины управления мультиплексорами 2 дифф канала  
DigitalOut DI20(PB_4);
DigitalOut DI21(PB_5);
DigitalOut DI22(PB_3);
DigitalOut DI23(PA_10);

//пины управления КУ  
DigitalOut AA0(PC_0);
DigitalOut AA1(PC_1);

//отруб ненужных каналов АЦП
BusOut adzero(PC_2,PC_3,PC_5);

//управление мультиплексорами
void mux_group();
int IE;
int j; //inject I
int k; //measure I
int belt;
float yprint[2080];


void mux();//универсальная процедура выбора канала
int P;//канал в mux 

void emux();// выбор пояса
void emux_init();//выключение всех поясов
void imux(); //выбор инжектирующего электрода
void igmux();//выбор земли
void DI1mux();//выбор первого  измерительного электрода
void DI2mux();//выбор второго измерительного электрода

//измерение 
void preamp();
int PA;

//связь с ПК
void five();
void four();
char key4[] = "4";
char key5[] = "5";
char buffer[2];

// переменные генератор-цап
int freqdata;
float amp;
int form;
void freq();
void freqsq();
void sinus();
void square();
void triangle();
void adc_read();
void request();
void rasputte();
void channel();
void amplitude();
int II; int IG; int DI1; int DI2;

void measure();
void ranging();
void ranging_1();
int sign;
int range;

void fout();

void belt_request();
void swap();
int diff;

int ymax;
void adc_read();
void adc_read1();
int yp;
int exf;


//секция тестирования
void ctest();
int ct;

static ADC_HandleTypeDef AdcHandle;

void adc_init() {
        // we assume AnalogIn has configureed GPIO, we need ADC channel ?  
        __ADC1_CLK_ENABLE();  // Enable ADC clock
        // Configure ADC
        AdcHandle.Instance = (ADC_TypeDef *)ADC1;
        AdcHandle.Init.ClockPrescaler        = ADC_CLOCKPRESCALER_PCLK_DIV2;
        AdcHandle.Init.Resolution            = ADC_RESOLUTION12b;
        AdcHandle.Init.ScanConvMode          = DISABLE;
        AdcHandle.Init.ContinuousConvMode    = ENABLE;    // DMA
        AdcHandle.Init.DiscontinuousConvMode = DISABLE;
        AdcHandle.Init.NbrOfDiscConversion   = 0;
        AdcHandle.Init.ExternalTrigConvEdge  = ADC_EXTERNALTRIGCONVEDGE_NONE;
        AdcHandle.Init.ExternalTrigConv      = ADC_EXTERNALTRIGCONV_T1_CC1;
        AdcHandle.Init.DataAlign             = ADC_DATAALIGN_RIGHT;
        AdcHandle.Init.NbrOfConversion       = 1;
        AdcHandle.Init.DMAContinuousRequests = ENABLE;    // DMA
        AdcHandle.Init.EOCSelection          = DISABLE;
        HAL_ADC_Init(&AdcHandle);
}

static DMA_HandleTypeDef DMA_Handle;

void dma_init() {
    //  DMA init  ADC1 is DMA2 channel0 stream 0 or 4 use DMA2_Stream0  thd

    __DMA2_CLK_ENABLE();
    DMA_Handle.Instance = DMA2_Stream0;
    DMA_Handle.State = HAL_DMA_STATE_READY;
    HAL_DMA_DeInit(&DMA_Handle);
    DMA_Handle.Init.Channel = DMA_CHANNEL_0;   
    DMA_Handle.Init.Direction = DMA_PERIPH_TO_MEMORY;
    DMA_Handle.Init.PeriphInc = DMA_PINC_DISABLE;
    DMA_Handle.Init.MemInc = DMA_MINC_ENABLE;
    DMA_Handle.Init.PeriphDataAlignment = DMA_PDATAALIGN_HALFWORD;
    DMA_Handle.Init.MemDataAlignment = DMA_MDATAALIGN_HALFWORD;
    DMA_Handle.Init.Mode =  DMA_NORMAL;
    DMA_Handle.Init.Priority = DMA_PRIORITY_HIGH;
    DMA_Handle.Init.FIFOMode = DMA_FIFOMODE_DISABLE;
    DMA_Handle.Init.FIFOThreshold = DMA_FIFO_THRESHOLD_HALFFULL;
    DMA_Handle.Init.MemBurst = DMA_MBURST_SINGLE;   
    DMA_Handle.Init.PeriphBurst = DMA_PBURST_SINGLE;
    HAL_DMA_Init(&DMA_Handle);

    __HAL_LINKDMA(&AdcHandle, DMA_Handle, DMA_Handle);
}

void adc_readn( uint16_t * data, uint32_t nelems) {
    ADC_ChannelConfTypeDef sConfig;
    sConfig.Channel = ADC_CHANNEL_14;  // PC_4
    sConfig.Rank = 1;
    sConfig.SamplingTime = ADC_SAMPLETIME_3CYCLES;
    sConfig.Offset = 0;
    HAL_ADC_ConfigChannel(&AdcHandle, &sConfig);
    HAL_ADC_Start_DMA(&AdcHandle, (uint32_t *)data, nelems);
    while (DMA_Handle.Instance->CR & DMA_SxCR_EN);   // spin
    HAL_ADC_Stop(&AdcHandle);
}

void button_check();

Timer t;

int main()
{   
    IEN = 1;
    adzero = 0;
    serial.baud(921600);
        ddsstop;dacstop;
        DDS.frequency(400000);
        DDS.format(16,2);
        ddsstart; DDS.write(0x21C2);
        ddsstart; DDS.write(0x20C2);
        ddsstop; // инициализация dds
        mclkstart
        wait_ms(1);
        //printf("10000000000000000\r\n");
    while(true) {
        emux_init();
        i2g;
        memset(yprint,0,sizeof yprint);
        exf = 0;
        belt_request();  
        if (belt > 10) {continue;}     
        ctest();
        if (ct == 1) {continue;}
        else {wait_us(10); printf("7\r\n"); fflush (stdout); wait_us(100);};
        ddsreset;
        request();
        int amountOfByte = sizeof(float) * 208 * belt;
        while(true){
        t.reset();
        t.start();
        rasputte();
        mux_group();
        t.stop(); 
        i2g;
        write(1, yprint, amountOfByte);
        //fout();
        //////////////////////////
       // for (yp = 0; yp < (208*belt); yp++) {printf("%.6f\r\n",yprint[yp]);};
        /////////////////////////
   // printf("1000r useconds %i\r\n", t.read_ms());
          wait_us(1);
          four();
          if (exf == 1){break;}
        }
         amp = 0.1;amplitude();sq=0.0;mclkstop;
          ddsoff;  
    }
}

void belt_request()
{
    fflush(stdout);
    fflush(stdin);
    scanf("%i",&belt);
    fflush(stdin);
    fflush(stdout);
    }

void fout()
{
    //printf("%.1g,%i\r\n", ampd[ampc], freqdata);
    printf("# name: data\r\n");
    printf("# type: scalar struct\r\n");
    printf("# ndims: 2\r\n");
    printf(" 1 1\r\n");
    printf("# length: 4\r\n");
    printf("# name: description\r\n");
    printf("# type: sq_string\r\n");
    printf("# elements: 1\r\n");
    printf("# length:  20\r\n");
    if (form == 1){printf("# sin %03i kHz %1.01f mA\r\n",freqdata,amp);}
    else if (form == 2){printf("# sqr %03i kHz %1.01f mA\r\n",freqdata,amp);}
    else {printf("# tri %03i kHz %1.01f mA\r\n",freqdata,amp);};
    printf("\r\n");
    printf("\r\n");
    printf("# name: meas_volts\r\n");
    printf("# type: matrix\r\n");
    printf("# rows: 208\r\n");
    printf("# columns: 1\r\n");
    for (yp = 0; yp < 208*belt; yp++) {printf("%.6g\r\n",yprint[yp]);};
    memset(yprint,0,sizeof yprint);
    printf("\r\n");
    printf("# name: time\r\n");
    printf("# type: scalar\r\n");
    printf("    %04i ms\r\n",t.read_ms());
    printf("\r\n");
    printf("# name: n_elec\r\n");
    printf("# type: scalar\r\n");
    printf(" 16\r\n");
    
}

void ctest()
{
    ct = 0;
    int mg = 0;
    int mj = 0;
    int aread=0;
    sign=1; PA=1; range=1; preamp();
    form = 1; freqdata = 50; amp = 5;
    sinus();wait_ms(10);
    for (mg = 0; mg < belt; mg++) {
        IE = mg; emux();
        for (mj = 0; mj < 15; mj+=2) {
            IG = mj; II = mj+1; DI1 = II; DI2 = IG;
            igmux(); imux(); DI1mux(); DI2mux();
            int xa = (int)5000/freqdata;
            int xaa = (int)xa/5;
            uint16_t x[xa];
            adc_init();
            dma_init();
            memset(x,0,sizeof x);
            adc_readn(x,xa);
            sort(x+xaa,x + xa);
            aread = (int)x[xa-1];
            if ((aread > 3500) &&(test_button.read() == 1))
            {printf("%i,%i\r\n",mg+1, mj+1); printf("%i,%i\r\n",mg+1, mj+2);ct = 1;}
        }
    
    }
    //mclkstop;
     }


void four()
{
      //printf("\r");
        fflush (stdout);
        fflush (stdin);
        scanf ("%2s",buffer);
        fflush (stdout);
        if (strcmp (key4,buffer) == 0){exf = 1;}
         }
 
 void five()
{
    do {
        fflush (stdout);
        scanf ("%2s",buffer);
    } while (strcmp (key5,buffer) != 0);
        wait_us(10);
       fflush (stdout);
}

void amplitude()
{
    uint16_t ampt;
    uint16_t ampReg;
    ampt = uint16_t(819.2*(5.0-amp));
    ampReg = uint16_t(ampt & 0xFFF);
    DAC.format(16,1);DAC.frequency(400000);
    dacstart;
    DAC.write(ampReg*4);
    dacstop;
    }

void freq ()
{
    ddsstart;
    float FreqReg;
    uint32_t ftemp;
    uint16_t Uptemp, Lowtemp;
    FreqReg = 26.8435456 * (uint32_t)freqdata*1000;
    ftemp = (uint32_t)FreqReg;
    Lowtemp = (uint16_t)(ftemp & 0x3FFF);
    Uptemp = (uint16_t)((ftemp/16384) & 0x3FFF);
    DDS.write(Lowtemp + 0x4000);
    ddsstart;
    DDS.write(Uptemp + 0x4000);
    ddsstop;
}

void freqsq ()
{
    int period;
    period = (int) 1000/freqdata;
    sq.period_us(period);
    sq.pulsewidth_us((int)period/2);
}

void sinus()
{
    ddsstart;
    sinsoft;
    freq();
    ddsstop;
    amplitude();
    mclkstart;
    }

void square()
{
    ddsstart;DDS.write(0x210A);ddsstart;DDS.write(0x4000);
    ddsstart;DDS.write(0x4000);ddsstart;DDS.write(0x8000);
    ddsstart;DDS.write(0x8000);ddsstart;DDS.write(0xCC00);
    ddsstart;DDS.write(0xE400);ddsstart;DDS.write(0x220A);
    ddsstop;
    amplitude();
    mclkstart;
    freqsq();
}

void triangle()
{
    ddsstart;
    trisoft;
    ddsstart;
    freq();
    ddsstop;
    amplitude();
    mclkstart;
}

void request()
{
   // printf("forma, chastota\r\n");
    fflush(stdout);
    fflush(stdin);
    scanf("%i,%i,%i,%f",&belt,&form,&freqdata,&amp);
    fflush(stdin);
    fflush(stdout);
    }
    
    

void rasputte()
{
    switch(form) {
        case (1):
            sinus();
            break;
        case (2):
            square();
            break;
        case (3):
            triangle();
            break;
    }
    }
    
void emux_init()
{
   P = 15; P0=&IE0; P1=&IE1; P2=&IE2; P3=&IE3; 
   mux();
}

void emux()
{
   P = IE; P0=&IE0; P1=&IE1; P2=&IE2; P3=&IE3; 
   mux();
}

void imux()
{
   P = II; P0=&II0; P1=&II1; P2=&II2; P3=&II3; 
   mux();
}

void igmux()
{
   P = IG; P0=&IG0; P1=&IG1; P2=&IG2; P3=&IG3; 
   mux();
}

void DI1mux()
{
   P = DI1; P0=&DI10; P1=&DI11; P2=&DI12; P3=&DI13; 
   mux();
}

void DI2mux()
{
   P = DI2; P0=&DI20; P1=&DI21; P2=&DI22; P3=&DI23; 
   mux();
}


void mux()
{
    switch (P) {
        case (0):  {*P0=0; *P1=0; *P2=0; *P3=0;} break;
        case (1):  {*P0=1; *P1=0; *P2=0; *P3=0;} break;
        case (2):  {*P0=0; *P1=1; *P2=0; *P3=0;} break;
        case (3):  {*P0=1; *P1=1; *P2=0; *P3=0;} break;
        case (4):  {*P0=0; *P1=0; *P2=1; *P3=0;} break;
        case (5):  {*P0=1; *P1=0; *P2=1; *P3=0;} break;
        case (6):  {*P0=0; *P1=1; *P2=1; *P3=0;} break;
        case (7):  {*P0=1; *P1=1; *P2=1; *P3=0;} break;
        case (8):  {*P0=0; *P1=0; *P2=0; *P3=1;} break;
        case (9):  {*P0=1; *P1=0; *P2=0; *P3=1;} break;
        case (10): {*P0=0; *P1=1; *P2=0; *P3=1;} break;
        case (11): {*P0=1; *P1=1; *P2=0; *P3=1;} break;
        case (12): {*P0=0; *P1=0; *P2=1; *P3=1;} break;
        case (13): {*P0=1; *P1=0; *P2=1; *P3=1;} break;
        case (14): {*P0=0; *P1=1; *P2=1; *P3=1;} break;
        case (15): {*P0=1; *P1=1; *P2=1; *P3=1;} break;
    }
}

void preamp()
{
    switch (PA)
    {
        case(1):    {AA0=0;AA1=0;} break;
        case(10):   {AA0=0;AA1=1;} break;
        case(100):  {AA0=1;AA1=0;} break;
        case(1000): {AA0=1;AA1=1;} break;
    }
}


void mux_group()
{
        yp=0;
        for (IE = 0; IE < belt; IE++) {
        emux();
        //wait_ms(20);
        //PA=100; range=100;preamp();
        channel();
    }
    //mclkstop;
}

void channel()
{
    j = 0;//inject
    k = 0;//measure
   for (j = 0; j<16; j++) {
        //button_check();
        if (j==15) {IG = j; II = 0;} else {IG = j; II = j+1;}
        igmux(); imux(); //DI1=IG; DI2=IG;  DI1mux(); DI2mux();
       //if ((j==0)&&(IE==0)){wait_ms(1);}
        for (k = 0; k<16; k++) {
                if (k==15) {DI1 = k;DI2 = 0;} else {DI1 = k; DI2 = k+1; }
                if ((DI1==II)||(DI1==IG)||(DI2==II)||(DI2==IG)){continue;}
                DI1mux(); 
                DI2mux();
                wait_us(10);
                measure();
              //  printf("\r\n");
             }
        }
        
    /*    for (j = 0; j<16; j++) {
        //button_check();
        if (j==15) {IG = j; II = 0;} else {IG = j; II = j+1;}
        DI1 = II;igmux(); imux();DI1mux();
        
               wait_ms(2);
               
                measure();}*/
   /*     while(1){
 printf("%s\r\n", "vvod II inJect ");
    fflush(stdout);    
    scanf("%i",&II);//инжект
    printf("%s\r\n", "vvod IG inJect ");
    fflush(stdout);    
    scanf("%i",&IG);//инжектIG
    igmux(); imux();
        //button_check();
    printf("%s\r\n", "vvod DI1");
    fflush(stdout);    
    scanf("%i",&DI1);//инжект
    DI1mux(); measure();}*/
        
    }


void measure()
{
   // ranging_1();
    adc_read1();
}

void ranging_1()//определение коэффициента усиления и знака
{
    int xa = (int)4000/freqdata;
  //  if (xa < 20){xa=20;}
   // else if (xa > 200){xa=200;};
    uint16_t x[xa];
    int s_ok=0;
    PA=100; range=100;preamp();
    adc_init();
    dma_init();
    adc_readn(x,xa);
    sort(x,x + xa);
    if ((x[xa-1] > 3950)||(x[0] < 50)) {range=10;wait_us(10);} 
    PA = range; preamp();
    memset(x,0,sizeof x);
}

void ranging()//определение коэффициента усиления и знака
{
    int xa = (int)8000/freqdata;
    if (xa < 100){xa=100;}
    else if (xa > 500){xa=500;};
    int xaa = (int)xa/3;
    uint16_t x[xa];
    int s_ok=0;
    //IG = 0; II = 1;DI1 = II;DI2=IG;igmux();imux();DI1mux();DI2mux();wait_ms(10);
    PA=100; range=100;preamp();
    //while(s_ok==0){
    adc_init();
    dma_init();
    memset(x,0,sizeof x);
    adc_readn(x,xa);
    //printf("non_sorted\r\n");
    //for (s_ok = 0; s_ok < xa; s_ok++) {printf("%i\r\n",x[s_ok]);};
    sort(x+xaa,x + xa);
     //printf("sorted\r\n");
    //for (s_ok = 0; s_ok < xa; s_ok++) {printf("%i\r\n",x[s_ok]);};
    ymax = (int)((x[xa-1]+x[xa-2])-(x[xaa]+x[xaa+1]))/2;
    if (ymax/PA <= 0.04) {range=1000;s_ok=1;wait_us(20);} 
        else if (((ymax/PA > 0.04)&&(ymax/PA <= 0.4))) {range=100;s_ok=1;wait_us(10);} 
        else if (((ymax/PA > 0.4)&&(ymax/PA <= 4))) {range=10;s_ok=1;wait_us(10);} 
        else if (ymax/PA > 4) {range=1;s_ok=1;wait_us(10);};
        
      /*  if (ymax <= 3) {range=1000;s_ok=1;wait_us(50);} 
        else if (((ymax/PA > 3)&&(ymax <= 35))) {range=100;s_ok=1;wait_us(50);} 
        else if (((ymax/PA > 35)&&(ymax <= 4096))) {range=10;s_ok=1;wait_us(50);} 
        else if (ymax/PA > 300) {range=1;s_ok=1;wait_us(50);};*/
//}
    PA = range; preamp();
    //printf("%i,%i,%i,%i\r\n",ymax,x[xa-(xaa+1)], x[0], range);
memset(x,0,sizeof x);
}

void swap()
{
    int diff = DI1;
    DI1 = DI2;
    DI2 = diff;
    DI1mux();
    DI2mux();   
}

void adc_read()//измерение и вывод со всеми коэффициентами
{
    int ya = (int)5000/freqdata;
    float ym = 0;
    if (ya < 50){ya=50;}
    else if (ya > 300){ya=300;};
    int yaa = (int)ya/20;
    uint16_t y[ya];
    adc_init();
    dma_init();
    memset(y,0,sizeof y);
    adc_readn(y,ya);
   // for (yp = 0; yp < 400; yp++) {printf("%i\r\n",y[yp]);};
    sort(y+yaa,y + ya);
    ym = ((y[ya-2]+y[ya-3]+y[ya-4]+y[ya-5])-(y[yaa+1]+y[yaa+2]+y[yaa+3]+y[yaa+4]))/8;
    yprint[yp]=(((ym)*3.3*10)/(4096*range));yp++;
    memset(y,0,sizeof y);
}

void adc_read1()//измерение и вывод со всеми коэффициентами
{
    int s_ok = 1;
    PA=100; range=100;preamp();
     float ym = 0;
     int ya = (int)10000/freqdata;
    if (ya < 50){ya=50;}
    else if (ya > 500){ya=500;};
    int yaa = (int)ya/20;
    uint16_t y[ya];
    while (s_ok == 1)
   {
    adc_init();
    dma_init();
    memset(y,0,sizeof y);
    adc_readn(y,ya);
    sort(y+yaa,y + ya);
    if ((y[ya-1] > 3950)||(y[yaa] < 50)) {range=10;wait_us(10);s_ok = 1;memset(y,0,sizeof y);} else {s_ok = 0;};
    PA = range; preamp();
   }
    ym = ((y[ya-1]+y[ya-2]+y[ya-3]+y[ya-4])-(y[yaa]+y[yaa+1]+y[yaa+2]+y[yaa+3]))/8;
    yprint[yp]=(((ym)*3.3*10)/(4096*range));yp++;
    memset(y,0,sizeof y);
}


void button_check()
{
    if (button.read() == 1) {
        wait_ms(10);
        if (button.read() == 1) {
            int amp1;
            amp1 = amp;
            amp = 0.1;
            amplitude();
            while (button.read() == 1);
            amp = amp1;
            amplitude();
        }
    }
}