
#include "mbed.h"
// Connect TX  RX (p9 p10)
// Connest RST (p11)
// use USB and type in the values for the 4D commands in a terminal window
// Sends out data in an IRQ mode and reads them back
// during display init LED4 goes on
// LED1 and LED2 indicate RX and TX interrupt routine activity
// LED3 changing indicate main loop running (doing nothing)

#define BAUDRATE 9600
// #define BAUDRATE 115200
// #define BAUDRATE 128000
// #define BAUDRATE 19200
// #define BAUDRATE 38400
// #define BAUDRATE 57600

Serial device(p9, p10);  // tx, rx
// USB and print back the received answers in a terminal window
Serial device_pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut rst(p11);

void Rx_interrupt();
void Rx_pc_interrupt();
void freeBUFFER(void);

// main test program
int main() {
    led4=1;
    device.baud(BAUDRATE);
    device_pc.baud(BAUDRATE);
    
    rst=1;
    wait_ms(200);
    rst=0;
    wait_ms(80);
    rst=1;
    wait(1);
    freeBUFFER();
    wait(2);
    device.putc('U'); // auto Baud Sync
    wait_ms(500);
    device.getc();
    wait_ms(200);
    device.putc('V');
    wait_ms(200);
    device.putc(0x01);
    wait_ms(200);
    device_pc.printf("### Display Ready\n");
    device_pc.printf("### Waiting for commands at %d bauds\n" ,BAUDRATE);
    freeBUFFER();
    // wait_ms(10000);
    
    led4=0;
    
    // Setup a serial interrupt function to receive data
    device.attach(&Rx_interrupt, Serial::RxIrq);
    // Setup a serial interrupt function to transmit data
    device_pc.attach(&Rx_pc_interrupt, Serial::RxIrq);

    while (1) {
            led3=1;
            wait_ms(300);
            led3=0;
            wait_ms(300);
    }
}

void freeBUFFER() {
    while (device.readable()) device.getc(); // clear buffer garbage
    while (device_pc.readable()) device_pc.getc(); // clear buffer garbage
}

// Interupt Routine to read in data from LCD serial port
void Rx_interrupt() {
    led1=1;
    device_pc.printf("Got a response from LCD : ");
    while (device.readable()) {
      device_pc.putc(device.getc());
    }  
    device_pc.printf("\n");
    led1=0;
    return;
}

// Interupt Routine to read in data from PC USB serial port
void Rx_pc_interrupt() {
    led2=1;
    while (device_pc.readable()) {
      device.putc(device_pc.getc());
    }
    led2=0;
    return;
}