#ifndef RGBLED_H
#define RGBLED_H

#include "PinNames.h"
#include "mbed.h"

/** \brief A wrapper for an RGB LED connected to a PWM. This class simplifies the
  *        setting of the color and also provides some basic color definitions.
 */
class RGBLed
{
public:
    RGBLed(PinName redPin, PinName greenPin, PinName bluePin);

    /** \Brief Initialize the LED */
    void init();
    
    /** \Brief Set the color of the RGB LED */
    void setColor(const float red, const float green, const float blue);

private:
    PwmOut m_red;
    PwmOut m_green;
    PwmOut m_blue;
};

#endif