/**********************************************************************
* Written by WAVToCode
* Date:             Sat Dec 07 06:47:23 PM
* FileName:         marimbaChimeC_8k_8bit_unsigned.C
* Interleaved:      N/A
* Signed:           No
* No. of channels:  1
* No. of samples:   4411
* Bits/Sample:      8
**********************************************************************/

#define NUM_ELEMENTS 4411

const unsigned char data_chime[NUM_ELEMENTS] = {
126, 126, 126, 126, 126, 126, 128, 126, /* 0-7 */
128, 126, 126, 127, 126, 127, 126, 127, /* 8-15 */
126, 127, 127, 127, 127, 127, 127, 127, /* 16-23 */
126, 128, 127, 127, 127, 127, 128, 127, /* 24-31 */
128, 128, 128, 128, 128, 128, 128, 128, /* 32-39 */
128, 128, 128, 128, 128, 128, 128, 128, /* 40-47 */
127, 128, 126, 128, 128, 127, 127, 127, /* 48-55 */
126, 128, 128, 128, 128, 128, 128, 127, /* 56-63 */
128, 127, 128, 127, 128, 127, 127, 127, /* 64-71 */
128, 128, 128, 127, 128, 127, 128, 127, /* 72-79 */
127, 127, 128, 128, 127, 127, 126, 127, /* 80-87 */
127, 127, 127, 127, 127, 127, 128, 128, /* 88-95 */
127, 127, 126, 126, 128, 129, 131, 125, /* 96-103 */
119, 125, 131, 133, 134, 145, 136,  92, /* 104-111 */
 90, 129, 156, 156, 114,  79,  81, 120, /* 112-119 */
170, 190, 158, 104,  63,  79, 134, 189, /* 120-127 */
190, 151,  89,  68,  86, 136, 195, 186, /* 128-135 */
145,  66,  64,  79, 217, 200, 104, 114, /* 136-143 */
 80,  86,  98, 145, 176, 191, 159, 103, /* 144-151 */
 40,  59, 136, 230, 227, 123,  10,   6, /* 152-159 */
108, 231,   7, 157,  32, 242,  75, 201, /* 160-167 */
247, 179,  77,  27,  76, 157, 191, 146, /* 168-175 */
109, 105, 140, 139, 120, 101, 120, 171, /* 176-183 */
197, 146,  59,  14,  90, 230,  19, 191, /* 184-191 */
 26, 217,  58, 231,  46, 213,  39, 211, /* 192-199 */
 38, 206,  25, 206,  60, 252,  59, 178, /* 200-207 */
223, 167,  78,  57, 121, 171, 156,  93, /* 208-215 */
 68, 123, 197, 191, 106,  22,  50, 161, /* 216-223 */
  4, 218,  81, 234,  25, 175,  33, 244, /* 224-231 */
 81, 222,  10, 174,  28, 235,  86, 243, /* 232-239 */
 32, 162, 241, 197,  85,  36,  86, 168, /* 240-247 */
185, 133,  77,  89, 156, 192, 148,  64, /* 248-255 */
 43, 125, 221, 231, 128,  14,  12, 137, /* 256-263 */
  6,   3, 123, 245, 250, 131,   6,   0, /* 264-271 */
125,   1,  11, 128, 234, 227, 129,  44, /* 272-279 */
 61, 140, 192, 169, 111,  89, 129, 171, /* 280-287 */
160, 101,  70, 115, 194, 213, 142,  42, /* 288-295 */
 17, 110, 228, 253, 146,   6, 230,  89, /* 296-303 */
230,  13, 159,  17, 240,  80, 210, 242, /* 304-311 */
157,  49,  27,  98, 183, 192, 132,  84, /* 312-319 */
100, 149, 166, 126,  84,  96, 165, 210, /* 320-327 */
168,  72,  23,  87, 201, 254, 182,  41, /* 328-335 */
237,  60, 205,  15, 194,  46, 228,  41, /* 336-343 */
182, 251, 190,  69,  13,  68, 164, 206, /* 344-351 */
162,  93,  79, 125, 164, 149, 105,  94, /* 352-359 */
141, 192, 177, 106,  44,  72, 174, 248, /* 360-367 */
206,  82, 253,  41, 177,  15, 225,  83, /* 368-375 */
238,  23, 161,   2, 223,  99,  11,  42, /* 376-383 */
145, 217, 193, 107,  61,  91, 156, 173, /* 384-391 */
134,  94, 111, 168, 186, 134,  65,  57, /* 392-399 */
139, 226, 225, 123,  17,  21, 137, 253, /* 400-407 */
250, 130,   6,   5, 122, 244, 248, 132, /* 408-415 */
 22,  20, 115, 210, 207, 124,  58,  68, /* 416-423 */
131, 171, 147,  95,  87, 128, 166, 148, /* 424-431 */
 86,  52, 100, 185, 213, 145,  44,  19, /* 432-439 */
 99, 218, 252, 159,  31,   1,  95, 224, /* 440-447 */
  2, 167,  45,  13,  94, 202, 228, 156, /* 448-455 */
 69,  52, 111, 172, 172, 120,  84, 105, /* 456-463 */
150, 159, 112,  69,  86, 156, 200, 164, /* 464-471 */
 74,  25,  77, 185, 242, 182,  63,   5, /* 472-479 */
 70, 194, 255, 193,  74,  19,  77, 189, /* 480-487 */
237, 180,  87,  55, 105, 177, 191, 141, /* 488-495 */
 88,  94, 143, 168, 138,  86,  77, 129, /* 496-503 */
185, 174, 100,  38,  59, 150, 219, 190, /* 504-511 */
 86,  11,  46, 158, 237, 203,  90,  15, /* 512-519 */
 51, 159, 230, 195, 103,  45,  77, 157, /* 520-527 */
200, 171, 107,  82, 117, 162, 162, 122, /* 528-535 */
 96, 118, 163, 173, 128,  69,  70, 135, /* 536-543 */
201, 192, 112,  34,  42, 136, 220, 211, /* 544-551 */
113,  26,  35, 129, 217, 210, 124,  47, /* 552-559 */
 53, 130, 194, 186, 125,  83,  97, 144, /* 560-567 */
167, 143, 107, 108, 144, 169, 143,  93, /* 568-575 */
 76, 118, 180, 194, 136,  57,  43, 112, /* 576-583 */
198, 211, 136,  43,  26, 102, 194, 211, /* 584-591 */
139,  56,  40, 103, 178, 192, 140,  81, /* 592-599 */
 78, 122, 161, 156, 121, 104, 125, 154, /* 600-607 */
150, 115,  88, 109, 162, 187, 150,  82, /* 608-615 */
 52,  99, 179, 212, 158,  69,  31,  87, /* 616-623 */
178, 215, 163,  76,  38,  84, 164, 197, /* 624-631 */
159,  94,  69, 103, 151, 165, 138, 108, /* 632-639 */
113, 139, 151, 130, 104, 108, 148, 180, /* 640-647 */
162, 106,  67,  94, 165, 209, 179,  99, /* 648-655 */
 46,  77, 160, 217, 189, 107,  50,  72, /* 656-663 */
147, 199, 181, 117,  72,  88, 138, 169, /* 664-671 */
155, 119, 104, 122, 144, 139, 116, 106, /* 672-679 */
130, 163, 161, 120,  78,  84, 140, 191, /* 680-687 */
181, 115,  56,  64, 135, 199, 192, 120, /* 688-695 */
 55,  59, 126, 188, 187, 127,  71,  73, /* 696-703 */
123, 167, 163, 124,  96, 104, 133, 144, /* 704-711 */
127, 108, 114, 141, 155, 131,  91,  82, /* 712-719 */
120, 171, 179, 129,  67,  59, 117, 183, /* 720-727 */
194, 135,  64,  52, 109, 179, 193, 141, /* 728-735 */
 78,  66, 110, 165, 175, 138,  99,  96, /* 736-743 */
124, 149, 144, 121, 112, 129, 148, 142, /* 744-751 */
111,  93, 113, 158, 175, 144,  89,  67, /* 752-759 */
106, 169, 194, 153,  84,  55,  95, 165, /* 760-767 */
196, 159,  94,  64,  96, 154, 181, 154, /* 768-775 */
107,  89, 111, 144, 153, 133, 114, 118, /* 776-783 */
137, 143, 125, 104, 110, 141, 165, 150, /* 784-791 */
106,  77,  96, 151, 184, 162, 102,  64, /* 792-799 */
 86, 148, 190, 170, 110,  68,  85, 141, /* 800-807 */
178, 165, 119,  88, 100, 135, 156, 144, /* 808-815 */
119, 111, 124, 138, 133, 114, 110, 128, /* 816-823 */
152, 150, 117,  87,  94, 135, 172, 165, /* 824-831 */
115,  72,  81, 134, 182, 176, 123,  76, /* 832-839 */
 80, 129, 175, 173, 130,  91,  93, 128, /* 840-847 */
158, 156, 129, 110, 116, 135, 140, 127, /* 848-855 */
115, 123, 142, 148, 127,  99,  97, 126, /* 856-863 */
162, 164, 127,  84,  80, 122, 170, 176, /* 864-871 */
133,  84,  75, 117, 166, 175, 139,  95, /* 872-879 */
 86, 117, 153, 161, 135, 109, 106, 125, /* 880-887 */
139, 135, 122, 119, 130, 141, 132, 111, /* 888-895 */
102, 119, 148, 159, 134,  96,  84, 113, /* 896-903 */
158, 172, 141,  94,  77, 108, 157, 176, /* 904-911 */
148, 102,  85, 110, 150, 165, 144, 113, /* 912-919 */
104, 120, 142, 145, 131, 118, 124, 137, /* 920-927 */
139, 124, 109, 117, 140, 156, 142, 110, /* 928-935 */
 91, 109, 149, 170, 150, 106,  82, 103, /* 936-943 */
149, 174, 155, 110,  86, 104, 144, 167, /* 944-951 */
151, 117, 100, 113, 138, 150, 138, 120, /* 952-959 */
117, 129, 139, 133, 118, 115, 130, 147, /* 960-967 */
143, 119,  97, 105, 136, 160, 151, 113, /* 968-975 */
 85,  96, 136, 165, 155, 116,  85,  94, /* 976-983 */
131, 161, 153, 120,  95, 102, 130, 148, /* 984-991 */
142, 121, 110, 119, 133, 135, 123, 116, /* 992-999 */
123, 138, 141, 125, 106, 105, 127, 151, /* 1000-1007 */
151, 122,  93,  93, 125, 157, 157, 124, /* 1008-1015 */
 91,  90, 121, 154, 156, 127,  98,  97, /* 1016-1023 */
122, 146, 146, 127, 111, 114, 128, 138, /* 1024-1031 */
132, 121, 120, 132, 141, 134, 117, 111, /* 1032-1039 */
124, 148, 154, 135, 107,  99, 123, 154, /* 1040-1047 */
162, 137, 104,  94, 119, 151, 161, 137, /* 1048-1055 */
108,  99, 118, 144, 151, 135, 114, 111, /* 1056-1063 */
124, 138, 137, 126, 119, 126, 135, 135, /* 1064-1071 */
123, 114, 121, 139, 149, 138, 114, 102, /* 1072-1079 */
117, 146, 158, 142, 111,  97, 114, 144, /* 1080-1087 */
159, 144, 114,  99, 112, 139, 152, 140, /* 1088-1095 */
118, 109, 117, 133, 138, 130, 121, 120, /* 1096-1103 */
128, 133, 126, 117, 118, 131, 142, 136, /* 1104-1111 */
118, 105, 113, 137, 153, 144, 118,  99, /* 1112-1119 */
109, 137, 156, 148, 121, 102, 109, 133, /* 1120-1127 */
151, 146, 124, 109, 114, 130, 141, 136, /* 1128-1135 */
123, 118, 124, 131, 130, 121, 118, 125, /* 1136-1143 */
136, 136, 123, 109, 111, 129, 146, 144, /* 1144-1151 */
123, 104, 106, 129, 152, 150, 127, 105, /* 1152-1159 */
106, 127, 149, 149, 130, 111, 110, 127, /* 1160-1167 */
141, 140, 127, 118, 120, 128, 132, 127, /* 1168-1175 */
121, 122, 131, 135, 128, 114, 112, 125, /* 1176-1183 */
141, 144, 129, 108, 105, 124, 149, 157, /* 1184-1191 */
135, 104,  90, 111, 143, 156, 144, 120, /* 1192-1199 */
106, 111, 126, 133, 132, 130, 134, 142, /* 1200-1207 */
143, 132, 116, 109, 116, 129, 139, 139, /* 1208-1215 */
135, 136, 137, 130, 114,  99, 101, 126, /* 1216-1223 */
157, 169, 151, 115,  92,  97, 120, 141, /* 1224-1231 */
145, 137, 133, 137, 142, 134, 113,  95, /* 1232-1239 */
 97, 120, 146, 160, 154, 134, 116, 106, /* 1240-1247 */
101, 103, 114, 134, 158, 165, 148, 116, /* 1248-1255 */
 88,  86, 108, 134, 147, 143, 136, 132, /* 1256-1263 */
132, 126, 108,  92,  94, 120, 155, 174, /* 1264-1271 */
162, 130, 100,  88,  99, 118, 136, 149, /* 1272-1279 */
156, 154, 141, 117,  95,  91, 107, 132, /* 1280-1287 */
153, 154, 143, 131, 122, 114, 104,  96, /* 1288-1295 */
102, 127, 156, 171, 156, 119,  86,  79, /* 1296-1303 */
 99, 129, 149, 152, 143, 134, 126, 116, /* 1304-1311 */
107, 102, 111, 132, 152, 159, 150, 129, /* 1312-1319 */
113, 108, 108, 116, 126, 142, 158, 162, /* 1320-1327 */
145, 116,  91,  89, 113, 145, 161, 155, /* 1328-1335 */
135, 118, 113, 116, 117, 116, 119, 131, /* 1336-1343 */
149, 157, 147, 122, 102,  98, 111, 132, /* 1344-1351 */
146, 151, 148, 140, 127, 111, 100, 106, /* 1352-1359 */
127, 152, 164, 155, 132, 113, 107, 115, /* 1360-1367 */
125, 130, 131, 135, 144, 150, 140, 117, /* 1368-1375 */
 96,  95, 115, 142, 157, 153, 134, 116, /* 1376-1383 */
106, 105, 110, 118, 130, 143, 149, 141, /* 1384-1391 */
124, 106, 100, 110, 123, 133, 135, 133, /* 1392-1399 */
133, 132, 125, 110,  98, 101, 120, 147, /* 1400-1407 */
159, 148, 125, 103,  98, 110, 125, 136, /* 1408-1415 */
140, 140, 138, 135, 125, 113, 108, 114, /* 1416-1423 */
129, 143, 147, 142, 133, 124, 119, 115, /* 1424-1431 */
113, 118, 133, 148, 154, 143, 120, 102, /* 1432-1439 */
101, 117, 136, 146, 141, 132, 126, 125, /* 1440-1447 */
125, 121, 116, 118, 130, 144, 150, 142, /* 1448-1455 */
127, 115, 113, 119, 128, 137, 143, 145, /* 1456-1463 */
141, 131, 116, 106, 110, 126, 145, 150, /* 1464-1471 */
142, 126, 114, 114, 120, 124, 125, 124, /* 1472-1479 */
131, 141, 145, 135, 118, 104, 105, 120, /* 1480-1487 */
139, 149, 148, 137, 126, 118, 113, 115, /* 1488-1495 */
121, 133, 144, 147, 139, 123, 111, 109, /* 1496-1503 */
116, 124, 128, 129, 132, 134, 134, 125, /* 1504-1511 */
109,  98, 103, 120, 140, 150, 142, 123, /* 1512-1519 */
107, 102, 109, 120, 128, 135, 139, 139, /* 1520-1527 */
133, 123, 111, 108, 114, 127, 138, 143, /* 1528-1535 */
140, 135, 127, 118, 109, 107, 116, 133, /* 1536-1543 */
150, 154, 141, 120, 104, 104, 116, 132, /* 1544-1551 */
141, 140, 137, 133, 129, 122, 114, 111, /* 1552-1559 */
116, 129, 143, 147, 141, 129, 117, 111, /* 1560-1567 */
112, 119, 130, 140, 148, 146, 133, 116, /* 1568-1575 */
107, 110, 124, 140, 146, 142, 134, 127, /* 1576-1583 */
123, 122, 119, 118, 122, 133, 145, 146, /* 1584-1591 */
137, 120, 107, 106, 115, 129, 138, 141, /* 1592-1599 */
138, 130, 120, 111, 108, 114, 127, 139, /* 1600-1607 */
145, 139, 128, 120, 118, 120, 124, 127, /* 1608-1615 */
131, 138, 144, 145, 134, 119, 109, 112, /* 1616-1623 */
126, 142, 149, 144, 132, 120, 115, 115, /* 1624-1631 */
119, 124, 131, 136, 138, 133, 122, 114, /* 1632-1639 */
111, 116, 124, 131, 135, 137, 136, 132, /* 1640-1647 */
123, 115, 111, 119, 134, 148, 151, 141, /* 1648-1655 */
125, 114, 113, 121, 130, 136, 137, 136, /* 1656-1663 */
134, 130, 121, 114, 111, 115, 126, 135, /* 1664-1671 */
137, 134, 126, 117, 110, 109, 114, 122, /* 1672-1679 */
135, 142, 141, 130, 116, 108, 111, 124, /* 1680-1687 */
135, 141, 138, 134, 129, 125, 122, 119, /* 1688-1695 */
117, 124, 134, 143, 144, 135, 122, 112, /* 1696-1703 */
110, 117, 127, 136, 141, 140, 133, 122, /* 1704-1711 */
113, 110, 115, 127, 138, 142, 139, 130, /* 1712-1719 */
124, 120, 120, 120, 123, 129, 138, 145, /* 1720-1727 */
144, 133, 119, 110, 113, 124, 137, 145, /* 1728-1735 */
143, 136, 127, 120, 117, 118, 123, 132, /* 1736-1743 */
139, 142, 138, 129, 120, 117, 118, 122, /* 1744-1751 */
127, 133, 138, 140, 135, 124, 113, 108, /* 1752-1759 */
115, 128, 140, 144, 137, 126, 117, 114, /* 1760-1767 */
117, 121, 127, 131, 135, 136, 132, 125, /* 1768-1775 */
116, 113, 117, 124, 132, 137, 137, 132, /* 1776-1783 */
125, 117, 112, 113, 121, 132, 140, 139, /* 1784-1791 */
131, 119, 112, 113, 120, 127, 130, 131, /* 1792-1799 */
132, 130, 128, 121, 116, 114, 119, 129, /* 1800-1807 */
137, 140, 135, 126, 118, 115, 117, 123, /* 1808-1815 */
130, 137, 139, 136, 127, 118, 114, 118, /* 1816-1823 */
126, 133, 136, 134, 130, 127, 124, 120, /* 1824-1831 */
118, 119, 125, 134, 140, 140, 132, 121, /* 1832-1839 */
114, 116, 123, 132, 139, 140, 137, 130, /* 1840-1847 */
124, 120, 119, 124, 131, 137, 139, 137, /* 1848-1855 */
130, 125, 121, 121, 121, 125, 130, 136, /* 1856-1863 */
139, 135, 125, 116, 112, 117, 127, 137, /* 1864-1871 */
140, 136, 129, 122, 120, 120, 123, 127, /* 1872-1879 */
132, 137, 137, 135, 128, 121, 118, 120, /* 1880-1887 */
126, 132, 137, 138, 135, 129, 121, 115, /* 1888-1895 */
116, 122, 132, 139, 139, 132, 122, 117, /* 1896-1903 */
117, 120, 125, 129, 132, 133, 133, 129, /* 1904-1911 */
123, 117, 116, 120, 129, 136, 139, 136, /* 1912-1919 */
129, 121, 117, 116, 122, 129, 137, 140, /* 1920-1927 */
137, 128, 120, 116, 118, 124, 131, 134, /* 1928-1935 */
134, 133, 130, 125, 120, 116, 118, 124, /* 1936-1943 */
133, 139, 138, 131, 122, 115, 115, 120, /* 1944-1951 */
128, 134, 137, 135, 131, 123, 118, 117, /* 1952-1959 */
120, 127, 133, 136, 135, 131, 126, 121, /* 1960-1967 */
119, 119, 123, 129, 136, 139, 136, 126, /* 1968-1975 */
118, 114, 117, 126, 133, 137, 135, 130, /* 1976-1983 */
124, 120, 118, 119, 123, 129, 134, 136, /* 1984-1991 */
133, 127, 121, 118, 119, 123, 129, 135, /* 1992-1999 */
139, 137, 131, 123, 117, 116, 123, 132, /* 2000-2007 */
139, 139, 134, 127, 122, 119, 120, 123, /* 2008-2015 */
127, 132, 135, 135, 131, 124, 118, 116, /* 2016-2023 */
119, 127, 133, 136, 136, 131, 125, 119, /* 2024-2031 */
116, 120, 127, 135, 139, 138, 131, 124, /* 2032-2039 */
119, 120, 124, 128, 132, 135, 135, 133, /* 2040-2047 */
128, 121, 116, 117, 122, 129, 136, 135, /* 2048-2055 */
131, 123, 117, 115, 117, 122, 128, 133, /* 2056-2063 */
134, 130, 123, 118, 115, 117, 123, 129, /* 2064-2071 */
132, 134, 132, 128, 123, 119, 117, 121, /* 2072-2079 */
128, 135, 139, 136, 128, 121, 117, 119, /* 2080-2087 */
124, 131, 135, 135, 133, 128, 122, 119, /* 2088-2095 */
118, 121, 127, 132, 134, 133, 128, 123, /* 2096-2103 */
119, 117, 119, 124, 131, 135, 136, 131, /* 2104-2111 */
123, 118, 117, 122, 130, 135, 138, 134, /* 2112-2119 */
131, 126, 123, 123, 124, 128, 133, 138, /* 2120-2127 */
138, 135, 129, 123, 120, 122, 127, 132, /* 2128-2135 */
136, 137, 134, 127, 121, 118, 120, 126, /* 2136-2143 */
132, 136, 135, 130, 124, 121, 120, 122, /* 2144-2151 */
125, 128, 132, 135, 133, 130, 123, 119, /* 2152-2159 */
120, 124, 131, 136, 137, 134, 128, 123, /* 2160-2167 */
120, 120, 125, 130, 135, 135, 133, 127, /* 2168-2175 */
122, 119, 120, 123, 127, 130, 131, 131, /* 2176-2183 */
128, 123, 119, 117, 119, 125, 132, 135, /* 2184-2191 */
134, 128, 122, 119, 120, 124, 128, 132, /* 2192-2199 */
135, 134, 131, 126, 122, 120, 122, 127, /* 2200-2207 */
132, 135, 134, 131, 126, 122, 119, 119, /* 2208-2215 */
123, 129, 134, 135, 131, 124, 119, 117, /* 2216-2223 */
121, 126, 131, 133, 132, 129, 126, 123, /* 2224-2231 */
120, 121, 124, 129, 134, 135, 133, 128, /* 2232-2239 */
123, 120, 121, 125, 130, 134, 135, 133, /* 2240-2247 */
128, 122, 119, 120, 124, 130, 134, 134, /* 2248-2255 */
130, 127, 123, 122, 121, 123, 126, 131, /* 2256-2263 */
134, 133, 130, 124, 120, 120, 123, 128, /* 2264-2271 */
134, 135, 133, 130, 125, 122, 121, 123, /* 2272-2279 */
128, 132, 135, 133, 129, 124, 122, 121, /* 2280-2287 */
123, 127, 129, 132, 133, 131, 127, 123, /* 2288-2295 */
119, 120, 124, 131, 134, 134, 131, 125, /* 2296-2303 */
120, 119, 123, 128, 129, 133, 133, 131, /* 2304-2311 */
127, 121, 124, 124, 124, 127, 133, 136, /* 2312-2319 */
135, 131, 123, 114, 119, 126, 133, 138, /* 2320-2327 */
142, 135, 108,  88, 127, 146, 144, 120, /* 2328-2335 */
 81,  85, 113, 171, 188, 226,  72, 229, /* 2336-2343 */
 72, 195, 240, 165,  81,  63,  85, 150, /* 2344-2351 */
192, 146,  99,  87, 156, 157, 128,  91, /* 2352-2359 */
105, 136, 177, 159,  91,  47, 104, 207, /* 2360-2367 */
231, 158,  61,  13,  71, 190,   2, 191, /* 2368-2375 */
 46, 249,  67, 198, 230, 192,  79,  29, /* 2376-2383 */
 69, 169, 197, 148,  65,  69, 136, 174, /* 2384-2391 */
159,  95,  71, 129, 195, 186, 101,  34, /* 2392-2399 */
 72, 185,   8, 209,  78, 235,  50, 196, /* 2400-2407 */
 35, 215,  82, 242,  45, 188,   4, 192, /* 2408-2415 */
 59,   7,  87, 197, 223, 146,  46,  44, /* 2416-2423 */
127, 208, 174,  75,  29, 103, 204, 237, /* 2424-2431 */
140,   8, 242, 120,  16,  30, 137, 235, /* 2432-2439 */
223, 123,  25,  38, 131, 223, 233, 140, /* 2440-2447 */
 25,   8, 117, 236, 251, 131, 249, 227, /* 2448-2455 */
 98,  11,  56, 153, 207, 151,  64,  46, /* 2456-2463 */
131, 209, 198,  94,  24,  65, 183, 249, /* 2464-2471 */
193,  69,  11,  89, 218,   9, 177,  47, /* 2472-2479 */
  3,  94, 220,   2, 168,  55,  18,  92, /* 2480-2487 */
182, 204, 135,  71,  71, 132, 175, 155, /* 2488-2495 */
101,  80, 126, 178, 175, 111,  67,  93, /* 2496-2503 */
182, 228, 178,  65,  23,  98, 220,  15, /* 2504-2511 */
182,  39, 237,  66, 208,  10, 177,  35, /* 2512-2519 */
243,  67, 190, 224, 138,  31,  15, 103, /* 2520-2527 */
193, 192, 104,  38,  69, 153, 199, 151, /* 2528-2535 */
 64,  49, 137, 230, 225, 120,  18,  29, /* 2536-2543 */
158,  18, 249, 111, 244,  16, 157,  12, /* 2544-2551 */
234,  91, 232,  12, 151, 246, 206,  79, /* 2552-2559 */
252,  34, 139, 204, 177,  91,  55,  97, /* 2560-2567 */
160, 165, 121,  79, 104, 176, 207, 156, /* 2568-2575 */
 76,  58, 131, 223, 229, 144,  47,  43, /* 2576-2583 */
141, 240, 236, 125,  19,  21, 127, 232, /* 2584-2591 */
226, 123,  31,  41, 130, 195, 177, 107, /* 2592-2599 */
 65, 103, 163, 180, 125,  72,  92, 166, /* 2600-2607 */
208, 165,  79,  42, 111, 217, 251, 159, /* 2608-2615 */
 28, 255, 107, 244,  22, 164,  16, 239, /* 2616-2623 */
 93, 232,   6, 155,  27,   9, 105, 213, /* 2624-2631 */
219, 125,  34,  48, 138, 202, 174,  93, /* 2632-2639 */
 51,  93, 171, 187, 119,  44,  53, 144, /* 2640-2647 */
216, 187,  83,   5,  42, 163, 244, 198, /* 2648-2655 */
 78,   5,  52, 172, 241, 194,  82,  22, /* 2656-2663 */
 76, 183, 229, 176,  93,  58, 108, 172, /* 2664-2671 */
185, 139,  94, 107, 154, 174, 128,  73, /* 2672-2679 */
 70, 138, 201, 188,  96,  26,  49, 152, /* 2680-2687 */
226, 189,  81,   9,  54, 170, 243, 193, /* 2688-2695 */
 82,  18,  72, 178, 233, 185,  95,  55, /* 2696-2703 */
109, 185, 199, 141,  80,  90, 156, 202, /* 2704-2711 */
168,  90,  49, 101, 185, 209, 139,  44, /* 2712-2719 */
 28, 116, 212, 218, 116,  12,  12, 121, /* 2720-2727 */
226, 226, 122,  18,  22, 124, 222, 214, /* 2728-2735 */
124,  48,  64, 144, 206, 184, 110,  71, /* 2736-2743 */
102, 163, 185, 147,  94,  90, 139, 178, /* 2744-2751 */
158,  94,  60, 101, 175, 203, 146,  61, /* 2752-2759 */
 35,  97, 188, 214, 146,  58,  41, 109, /* 2760-2767 */
191, 205, 140,  70,  63, 126, 188, 184, /* 2768-2775 */
130,  88, 100, 143, 168, 142, 102, 101, /* 2776-2783 */
143, 179, 156,  94,  59,  94, 169, 204, /* 2784-2791 */
155,  67,  35,  90, 179, 213, 151,  55, /* 2792-2799 */
 24,  92, 187, 216, 149,  58,  34,  97, /* 2800-2807 */
179, 199, 143,  76,  69, 122, 174, 166, /* 2808-2815 */
112,  77, 104, 159, 180, 137,  80,  71, /* 2816-2823 */
128, 186, 181, 114,  54,  68, 146, 209, /* 2824-2831 */
186, 101,  35,  59, 146, 210, 189, 108, /* 2832-2839 */
 47,  67, 138, 190, 171, 112,  73,  96, /* 2840-2847 */
145, 167, 145, 108, 100, 128, 155, 146, /* 2848-2855 */
117, 103, 130, 167, 170, 127,  84,  86, /* 2856-2863 */
142, 195, 189, 124,  63,  71, 138, 199, /* 2864-2871 */
192, 127,  67,  75, 138, 189, 175, 117, /* 2872-2879 */
 77,  95, 146, 173, 152, 110,  99, 127, /* 2880-2887 */
159, 154, 116,  92, 117, 165, 184, 146, /* 2888-2895 */
 84,  66, 114, 183, 202, 148,  71,  50, /* 2896-2903 */
107, 184, 201, 140,  62,  45, 103, 177, /* 2904-2911 */
194, 137,  68,  55, 107, 164, 171, 128, /* 2912-2919 */
 87,  92, 132, 157, 140, 106,  96, 129, /* 2920-2927 */
165, 162, 120,  86, 100, 151, 183, 160, /* 2928-2935 */
101,  68,  98, 161, 194, 158,  89,  56, /* 2936-2943 */
 87, 152, 184, 153,  94,  67,  93, 142, /* 2944-2951 */
161, 134,  98,  93, 121, 147, 142, 115, /* 2952-2959 */
103, 121, 150, 154, 126,  97, 106, 148, /* 2960-2967 */
181, 164, 108,  72,  95, 157, 199, 175, /* 2968-2975 */
105,  60,  82, 148, 190, 166, 103,  66, /* 2976-2983 */
 88, 144, 174, 150, 100,  78, 103, 145, /* 2984-2991 */
158, 132, 102, 102, 132, 153, 138, 106, /* 2992-2999 */
 94, 124, 165, 173, 133,  87,  80, 127, /* 3000-3007 */
181, 184, 134,  80,  77, 128, 180, 180, /* 3008-3015 */
130,  78,  78, 126, 172, 171, 129,  89, /* 3016-3023 */
 91, 125, 153, 147, 121, 106, 119, 138, /* 3024-3031 */
138, 119, 103, 113, 142, 157, 136, 101, /* 3032-3039 */
 89, 118, 158, 168, 133,  89,  81, 123, /* 3040-3047 */
169, 177, 136,  87,  81, 120, 166, 172, /* 3048-3055 */
138,  99,  97, 127, 153, 149, 124, 107, /* 3056-3063 */
118, 141, 148, 128, 106, 109, 134, 153, /* 3064-3071 */
141, 108,  89, 111, 153, 171, 143,  93, /* 3072-3079 */
 73, 107, 161, 184, 152,  98,  75, 105, /* 3080-3087 */
158, 177, 148, 103,  87, 114, 153, 164, /* 3088-3095 */
137, 104,  97, 121, 146, 144, 121, 105, /* 3096-3103 */
114, 136, 141, 120,  97, 100, 130, 157, /* 3104-3111 */
149, 113,  84,  94, 135, 167, 156, 115, /* 3112-3119 */
 87, 100, 141, 169, 156, 118,  94, 106, /* 3120-3127 */
143, 163, 151, 121, 107, 118, 138, 144, /* 3128-3135 */
130, 118, 122, 137, 142, 127, 106, 105, /* 3136-3143 */
128, 151, 148, 118,  93,  99, 134, 162, /* 3144-3151 */
154, 114,  85,  97, 140, 171, 160, 118, /* 3152-3159 */
 89, 100, 139, 165, 155, 122, 102, 116, /* 3160-3167 */
143, 155, 138, 115, 111, 132, 150, 146, /* 3168-3175 */
122, 105, 117, 144, 154, 135, 104,  96, /* 3176-3183 */
121, 156, 163, 131,  91,  84, 118, 158, /* 3184-3191 */
166, 133,  95,  88, 118, 153, 158, 131, /* 3192-3199 */
102, 101, 126, 149, 148, 127, 110, 115, /* 3200-3207 */
132, 142, 133, 120, 119, 132, 144, 135, /* 3208-3215 */
114, 103, 118, 143, 154, 135, 105,  93, /* 3216-3223 */
112, 143, 153, 131, 101,  92, 114, 143, /* 3224-3231 */
149, 129, 103,  98, 118, 141, 144, 127, /* 3232-3239 */
111, 113, 130, 139, 131, 117, 116, 133, /* 3240-3247 */
147, 143, 121, 105, 113, 140, 157, 145, /* 3248-3255 */
115,  97, 111, 144, 161, 143, 108,  90, /* 3256-3263 */
108, 143, 161, 143, 110,  94, 110, 139, /* 3264-3271 */
151, 137, 115, 109, 123, 142, 143, 128, /* 3272-3279 */
115, 121, 138, 147, 137, 120, 115, 130, /* 3280-3287 */
147, 148, 128, 109, 111, 135, 154, 150, /* 3288-3295 */
122, 100, 103, 129, 151, 147, 122, 102, /* 3296-3303 */
106, 127, 143, 139, 120, 109, 117, 132, /* 3304-3311 */
139, 133, 122, 120, 129, 137, 133, 123, /* 3312-3319 */
120, 131, 144, 145, 128, 111, 111, 132, /* 3320-3327 */
151, 150, 128, 105, 105, 128, 148, 146, /* 3328-3335 */
123, 103, 106, 127, 145, 141, 120, 105, /* 3336-3343 */
110, 128, 139, 134, 119, 115, 123, 135, /* 3344-3351 */
134, 123, 114, 120, 137, 146, 135, 116, /* 3352-3359 */
107, 120, 143, 151, 135, 111, 104, 121, /* 3360-3367 */
146, 151, 133, 107, 100, 118, 143, 149, /* 3368-3375 */
132, 111, 104, 118, 136, 139, 127, 115, /* 3376-3383 */
116, 127, 135, 130, 119, 117, 125, 136, /* 3384-3391 */
136, 124, 114, 119, 134, 144, 136, 118, /* 3392-3399 */
109, 119, 140, 150, 139, 117, 107, 116, /* 3400-3407 */
136, 146, 138, 120, 112, 119, 133, 139, /* 3408-3415 */
131, 120, 118, 126, 134, 133, 125, 121, /* 3416-3423 */
125, 133, 134, 126, 118, 122, 135, 146, /* 3424-3431 */
140, 123, 111, 118, 138, 152, 145, 125, /* 3432-3439 */
112, 117, 136, 150, 144, 125, 113, 120, /* 3440-3447 */
136, 145, 138, 124, 114, 120, 132, 136, /* 3448-3455 */
130, 121, 120, 127, 132, 127, 117, 114, /* 3456-3463 */
123, 136, 139, 127, 113, 111, 124, 140, /* 3464-3471 */
142, 128, 112, 112, 128, 144, 144, 129, /* 3472-3479 */
112, 112, 127, 141, 141, 129, 117, 116, /* 3480-3487 */
124, 132, 131, 123, 119, 123, 127, 126, /* 3488-3495 */
120, 116, 119, 127, 131, 125, 115, 113, /* 3496-3503 */
122, 135, 136, 125, 111, 111, 123, 139, /* 3504-3511 */
142, 130, 115, 112, 123, 137, 140, 131, /* 3512-3519 */
119, 119, 127, 135, 134, 125, 121, 123, /* 3520-3527 */
130, 132, 128, 121, 122, 129, 133, 129, /* 3528-3535 */
120, 115, 122, 135, 141, 132, 117, 111, /* 3536-3543 */
120, 136, 144, 135, 119, 113, 121, 136, /* 3544-3551 */
143, 134, 121, 116, 124, 136, 140, 133, /* 3552-3559 */
122, 120, 126, 133, 134, 127, 124, 127, /* 3560-3567 */
133, 133, 127, 120, 121, 130, 138, 136, /* 3568-3575 */
125, 117, 119, 132, 140, 137, 125, 116, /* 3576-3583 */
120, 133, 142, 137, 124, 117, 120, 131, /* 3584-3591 */
138, 135, 127, 122, 125, 130, 132, 128, /* 3592-3599 */
125, 126, 131, 133, 129, 122, 121, 128, /* 3600-3607 */
135, 133, 125, 118, 119, 129, 138, 135, /* 3608-3615 */
123, 114, 116, 129, 138, 136, 125, 115, /* 3616-3623 */
116, 126, 135, 133, 125, 119, 121, 129, /* 3624-3631 */
132, 128, 122, 122, 126, 130, 130, 125, /* 3632-3639 */
122, 125, 132, 133, 127, 118, 116, 124, /* 3640-3647 */
135, 137, 127, 116, 113, 122, 133, 136, /* 3648-3655 */
128, 118, 115, 123, 132, 134, 127, 119, /* 3656-3663 */
119, 125, 133, 134, 128, 124, 124, 128, /* 3664-3671 */
130, 129, 127, 128, 132, 134, 132, 125, /* 3672-3679 */
122, 126, 134, 137, 132, 124, 120, 125, /* 3680-3687 */
133, 136, 131, 122, 119, 125, 133, 136, /* 3688-3695 */
131, 122, 119, 123, 130, 132, 129, 125, /* 3696-3703 */
125, 128, 129, 128, 125, 125, 129, 132, /* 3704-3711 */
132, 126, 122, 125, 131, 135, 132, 124, /* 3712-3719 */
120, 124, 133, 138, 134, 124, 118, 122, /* 3720-3727 */
132, 138, 134, 125, 119, 122, 129, 132, /* 3728-3735 */
130, 124, 122, 124, 129, 129, 125, 122, /* 3736-3743 */
123, 127, 129, 126, 122, 122, 126, 130, /* 3744-3751 */
130, 124, 119, 120, 127, 134, 133, 126, /* 3752-3759 */
118, 119, 126, 133, 133, 127, 121, 121, /* 3760-3767 */
126, 131, 131, 125, 121, 122, 126, 129, /* 3768-3775 */
128, 125, 124, 125, 126, 125, 122, 122, /* 3776-3783 */
126, 130, 129, 125, 120, 120, 126, 132, /* 3784-3791 */
132, 126, 121, 121, 128, 133, 133, 127, /* 3792-3799 */
121, 122, 127, 133, 133, 128, 123, 122, /* 3800-3807 */
126, 129, 129, 126, 126, 127, 129, 128, /* 3808-3815 */
125, 123, 125, 130, 132, 129, 124, 122, /* 3816-3823 */
126, 132, 135, 130, 124, 122, 127, 135, /* 3824-3831 */
137, 132, 124, 121, 126, 133, 136, 132, /* 3832-3839 */
127, 124, 126, 130, 132, 130, 126, 126, /* 3840-3847 */
128, 129, 129, 127, 126, 128, 129, 129, /* 3848-3855 */
126, 125, 126, 131, 133, 130, 125, 122, /* 3856-3863 */
125, 132, 135, 133, 127, 124, 125, 130, /* 3864-3871 */
133, 132, 127, 125, 126, 129, 130, 129, /* 3872-3879 */
125, 125, 125, 126, 126, 125, 125, 126, /* 3880-3887 */
126, 126, 122, 121, 123, 128, 130, 128, /* 3888-3895 */
122, 119, 122, 128, 131, 129, 125, 121, /* 3896-3903 */
122, 128, 132, 130, 125, 122, 123, 128, /* 3904-3911 */
131, 131, 127, 124, 125, 126, 128, 127, /* 3912-3919 */
125, 126, 127, 128, 126, 124, 123, 126, /* 3920-3927 */
129, 129, 126, 122, 122, 126, 130, 131, /* 3928-3935 */
126, 122, 122, 127, 132, 132, 128, 124, /* 3936-3943 */
122, 126, 130, 132, 129, 126, 125, 126, /* 3944-3951 */
129, 129, 128, 127, 128, 129, 128, 126, /* 3952-3959 */
126, 128, 129, 129, 126, 125, 125, 128, /* 3960-3967 */
131, 131, 128, 123, 123, 126, 132, 132, /* 3968-3975 */
129, 125, 124, 126, 130, 131, 129, 126, /* 3976-3983 */
126, 128, 130, 130, 128, 127, 128, 128, /* 3984-3991 */
129, 128, 127, 128, 129, 129, 128, 125, /* 3992-3999 */
123, 126, 130, 132, 129, 124, 122, 125, /* 4000-4007 */
129, 131, 129, 125, 122, 125, 129, 131, /* 4008-4015 */
128, 125, 122, 124, 127, 129, 128, 127, /* 4016-4023 */
125, 125, 126, 126, 126, 126, 127, 128, /* 4024-4031 */
127, 125, 124, 125, 127, 129, 128, 125, /* 4032-4039 */
123, 125, 128, 129, 128, 125, 122, 123, /* 4040-4047 */
127, 130, 129, 126, 124, 123, 126, 128, /* 4048-4055 */
128, 127, 126, 126, 126, 126, 126, 126, /* 4056-4063 */
126, 128, 127, 126, 125, 125, 128, 129, /* 4064-4071 */
128, 126, 124, 125, 129, 131, 130, 126, /* 4072-4079 */
124, 124, 128, 131, 131, 128, 125, 125, /* 4080-4087 */
128, 129, 129, 128, 126, 126, 128, 129, /* 4088-4095 */
128, 128, 126, 126, 127, 127, 126, 126, /* 4096-4103 */
128, 129, 129, 126, 125, 125, 127, 130, /* 4104-4111 */
130, 128, 125, 125, 126, 129, 131, 129, /* 4112-4119 */
126, 126, 127, 130, 131, 129, 127, 126, /* 4120-4127 */
126, 129, 129, 129, 128, 128, 126, 126, /* 4128-4135 */
126, 126, 128, 128, 128, 126, 125, 125, /* 4136-4143 */
126, 128, 129, 127, 125, 125, 126, 129, /* 4144-4151 */
129, 128, 125, 125, 126, 129, 130, 129, /* 4152-4159 */
127, 125, 126, 128, 128, 128, 128, 127, /* 4160-4167 */
127, 127, 126, 126, 126, 126, 128, 126, /* 4168-4175 */
125, 125, 125, 128, 128, 126, 125, 123, /* 4176-4183 */
125, 128, 129, 128, 125, 124, 125, 128, /* 4184-4191 */
129, 129, 128, 125, 126, 128, 128, 128, /* 4192-4199 */
127, 126, 126, 127, 128, 128, 127, 126, /* 4200-4207 */
126, 126, 126, 125, 126, 128, 128, 128, /* 4208-4215 */
125, 124, 125, 127, 129, 129, 128, 125, /* 4216-4223 */
125, 127, 129, 129, 128, 126, 126, 128, /* 4224-4231 */
129, 129, 128, 128, 126, 128, 128, 129, /* 4232-4239 */
129, 129, 128, 128, 126, 126, 126, 128, /* 4240-4247 */
129, 129, 126, 125, 125, 128, 129, 129, /* 4248-4255 */
126, 125, 125, 127, 129, 129, 127, 125, /* 4256-4263 */
125, 126, 129, 129, 128, 126, 126, 126, /* 4264-4271 */
128, 128, 128, 128, 128, 128, 128, 126, /* 4272-4279 */
126, 126, 128, 128, 126, 125, 125, 126, /* 4280-4287 */
128, 128, 126, 125, 124, 125, 128, 128, /* 4288-4295 */
127, 125, 124, 125, 126, 128, 128, 126, /* 4296-4303 */
125, 126, 126, 127, 127, 126, 126, 126, /* 4304-4311 */
126, 126, 126, 127, 128, 128, 126, 125, /* 4312-4319 */
125, 126, 128, 129, 128, 125, 125, 126, /* 4320-4327 */
128, 129, 128, 126, 126, 126, 128, 128, /* 4328-4335 */
128, 126, 126, 126, 128, 128, 128, 128, /* 4336-4343 */
127, 128, 128, 128, 128, 128, 128, 128, /* 4344-4351 */
128, 126, 126, 126, 128, 129, 128, 126, /* 4352-4359 */
125, 126, 128, 129, 128, 126, 125, 126, /* 4360-4367 */
128, 129, 128, 126, 125, 126, 128, 128, /* 4368-4375 */
128, 128, 126, 126, 128, 128, 128, 128, /* 4376-4383 */
128, 128, 128, 128, 126, 126, 128, 128, /* 4384-4391 */
128, 126, 126, 126, 128, 129, 128, 126, /* 4392-4399 */
125, 126, 128, 129, 129, 128, 126, 126, /* 4400-4407 */
127, 128, 129}; /* 4408-4410 */


//get and set the frequency from wav conversion tool GUI
int ch=0;

//interrupt routine to play next audio sample from array in flash
void audio_sample_marimbaChime()
{

    speaker = data_chime[ch]/255.0;//scale to 0.0 to 1.0 for PWM
    ch++;
    if (ch>= NUM_ELEMENTS) {
        ch = 0;
        sampletick.detach();
        myled = 0;
    }
}
