#include "mbed.h"
#include "rtos.h"
#include "mpr121.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include <vector>

PwmOut speaker(p25);
Ticker sampletick;
DigitalOut myled(LED1);

#include "dixiehorn.h"
#include "guitarjazz.h"
#include "marimbaAmin.h"
#include "marimbaChimeC.h"
#include "marimbaFmaj.h" 
#include "marimbaGmaj.h"
#include "marimbaHighD.h"
#include "marimbaLowC.h"
#include "snare.h"
#include "splash.h"
#include "tomHigh.h"
#include "kick.h"

#define sample_freq 8000.0
#define SECOND 1000
#define RED 0xFF0000
#define BLACK 0x000000

using namespace std;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
PinDetect pbRec(p17);
PinDetect pbPlay(p16);
DigitalOut led(p23);

// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);
// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)

int key_code;

//Bluetooth

Serial pc(USBTX, USBRX);

// initialize recording capability
vector<int> sequence;
volatile bool isrec = false;
volatile bool play = false;

Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

uLCD_4DGL uLCD(p13, p14, p29); // lcd used by the following threads
Mutex stdio_mutex;

void fallInterrupt()
{
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    // LED demo mod
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
    }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
    
//    fclose(wave_file); 
}

void ledRecord(void const *args) {
    while(1) {
        if(isrec) led = !led;
        else led = 0;
        Thread::wait(1 * SECOND);  
    }
}

void pbRec_hit_callback (void) {
    if (!isrec) {isrec = true; sequence.clear();}
    else if(isrec) {isrec = false;}
}

void pbPlay_hit_callback (void) {
    if (!play) {play = true;}
    else if(play) {play = false;}
}

void playback(int num) {
    switch(num) { //uses a case statement for each individual touch sensor
        case 1:
            led = 1;
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(0,93,42,124,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_dixiehorn, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 2:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(0,62,42,93,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_guitarjazz, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 3:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(0,31,42,62,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_marimbaA, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 4:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(0,0,42,31,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_marimbaChime, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 5:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(42,93,84,124,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_marimbaF, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 6:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(42,62,84,93,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_marimbaG, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 7:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(42,31,84,62,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_marimbaD, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 8:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(42,0,84,31,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_marimbaC, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 9:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(84,93,127,124,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_snare, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 10:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(84,62,127,93,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_splash, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 11:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(84,31,127,62,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_tomHigh, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
        case 12:
            if (isrec) sequence.push_back(num);
            stdio_mutex.lock();
            uLCD.filled_rectangle(84,0,127,31,RED);
            stdio_mutex.unlock();
            sampletick.attach(&audio_sample_kick, 1.0 / sample_freq);
            Thread::wait(.75 * SECOND);
            break;
    }
}

void initialize() {
    speaker.period(1.0/250000.0); //PWM freq >10X audio sample rate
    pbRec.mode(PullUp);
    pbPlay.mode(PullUp);
    wait(.001);
    pbRec.attach_deasserted(&pbRec_hit_callback);
    pbPlay.attach_deasserted(&pbPlay_hit_callback);
    pbRec.setSampleFrequency();
    pbPlay.setSampleFrequency();

    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
}

int main()
{
    initialize();
//    Thread thread2(bluetooth, NULL, osPriorityNormal, 2000, NULL);
    Thread thread2(ledRecord, NULL, osPriorityNormal, 2000, NULL); 
//    Thread thread3(bluetooth, NULL, osPriorityNormal, 2000, NULL);
    //defaultscreen();
    while (1) {
        //uLCD.printf("play = %i", (int)play);
        if (play) {
            for (int j=0; j < sequence.size(); j++) {
                if (play) playback(sequence[j]);
                else break;
            }
        }
//        Thread thread2(layeredAudio);
        playback(key_code);
        uLCD.cls();
    }
}