#include "mbed.h"
/*
DigitalOut myled(LED1);

int main() {
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
*/

#include <LPC17xx.h>
#include <stdlib.h>
#include "typedefs.h"
#include "UARTs.h"

PwmOut led1(LED1);

int
main()
{
	UI_32 x, n;
	LPC_SC_TypeDef *sc;

	sc=(LPC_SC_TypeDef *) LPC_SC;
	n=sc->PCLKSEL0;

	init_UARTs(UART0,DATABITS5,STOPBITS1,PARITYFORCED1,BREAKDISABLE);
	init_UARTs(UART1,DATABITS6,STOPBITS2,PARITYFORCED0,BREAKDISABLE);
	init_UARTs(UART2,DATABITS7,STOPBITS1,PARITYODD,BREAKDISABLE);
	init_UARTs(UART3,DATABITS8,STOPBITS2,PARITYEVEN,BREAKDISABLE);

	for(x=0;x<n;x++)
	{
        led1 = (sinf(x)+1)/4;
        wait(0.01);
	}

    led1 = 0.5;
	return 0;
}
