#include <LPC17xx.h>
#include "typedefs.h"
#include "UARTs.h"

void
init_UARTs( UI_8 number_of_UART		/* number of interface 0=UART0, 1=UART1, 2=UART2, 3=UART3 */
			,UI_8 data_bits_count	/* count of data bits  5,6,7,8 */
			,UI_8 stop_bits_count 	/* count of stop bits  1=1, 2=2 (if data_bits==5 then stopbits=1and1/2) */
			,UI_8 type_of_parity	/* type of parity      0=fixed "0", 1=fixed "1", 2=odd , 3=even, 4=none (without parity bit) */
			,UI_8 break_control		/* 0=disable 1=enable */

			)
{
	LPC_UART_TypeDef *uart;

	switch(number_of_UART)
	{
		case UART0: uart=(LPC_UART_TypeDef *) LPC_UART0; break;
		case UART1: uart=(LPC_UART_TypeDef *) LPC_UART1; break;
		case UART2: uart=(LPC_UART_TypeDef *) LPC_UART2; break;
		case UART3: uart=(LPC_UART_TypeDef *) LPC_UART3; break;
	}
	uart->LCR=(data_bits_count-(UI_8) 5)|((stop_bits_count-(UI_8) 1)<<2)|(type_of_parity<<3)|(break_control<<6);
	uart->LCR|=MASK_DIVISOR_LATCH_ACCESS_BIT;
	uart->DLL=
	uart->DLM=
	uart->LCR&=~MASK_DIVISOR_LATCH_ACCESS_BIT;


//   /* Initialize the serial interface */
//   rbuf.in   = 0;
//   rbuf.out  = 0;
//   tbuf.in   = 0;
//   tbuf.out  = 0;
//   tx_active = __FALSE;
//
//   /* Enable RxD1 and TxD1 pins. */
//   PINSEL0 = 0x00050000;
//   /* 8-bits, no parity, 1 stop bit */
//   U1LCR = 0x83;
//   /* 19200 Baud Rate @ 15MHz VPB Clock */
//   U1DLL = 49;
//   U1DLM = 0;
//   U1LCR = 0x03;
//   /* Enable RDA and THRE interrupts. */
//   U1IER = 0x03;
//   /* Enable UART1 interrupts. */
//   VICVectAddr14  = (U32)handler_UART1;
//   VICVectCntl14  = 0x27;
//   VICIntEnable  |= 1 << 7;
}
