#include "mbed.h"
#include "led.h"
#include "buzzer.h"


Timer debounce;                                //tajmer koji koristimo za debounce
InterruptIn button(D7);                        //definiranje tipke za hardverski prekid
LED led1(D3);                                  //definiranje pina za zelena ledicu
LED led2(D4);                                  //definiranje pina za crvena ledicu
Beep buzzer(D5);                               //definiranje pina za zvučnik
DigitalOut ledica(LED2);                       //definiranje ledice na Nucleo pločici
Ticker blink;                                  //definiranje tickera
int a=0;                                       //definiranje integera u nulu
int b=0;
int x=0;
 
//Frequency                                                                                            //Frekvencija svakog tona melodije
float a4=440.00;float b3=246.94;float b4b=446;float b4=493.88; 
float c4=261.63;float c4_1=130;float c5=523.25;float c5s=554.40;
float d4=293.66;float d4b=277;float d5=587.33;
float e4=329.63;float e5=659.25; 
float f4=349.23;float f4s=370.00;float f5=698.46;
float g3=196; float g4=392.00;float g4s=415.30;float g5=783.99;

//Duration                                                                                               //trajanje tonova
float t1=16; float t2=8; float t3=4; float t4=2; float t5=6;


//"Happy Birthday song"                                                                                  //prva melodija
float happy_freq[25] = {g4,g4,a4,g4,c5,b4,g4,g4,a4,g4,d5,c5,g4,g4,g5,e5,c5,b4,a4,f5,f5,e5,c5,d5,c5};
float happy_tempo[25] = {t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t3,t2,t3,t3,t3,t3,t3,t3};                            
                             
void song1() 
{ 
        for(a=0; a<25; a++) {                                                          //petlja za prvu melodiju 
            buzzer.beep(happy_freq[a], happy_tempo[a]);
            led1.state(1);                                                             
            wait(0.05);
            led1.state(0);
            wait(1/happy_tempo[a]);                                                    //paljenje i gašenje ledica u ritmu melodije
            if(x==2){                                                                  //pritiskom na tipkalo petlja se prekida i pokreće druga melodija
                break;}
        }
}

//''Scary song''
float scary_freq[20]={c5s, f4s, f4s, c5s, f4s, f4s, c5s, f4s, d5, f4s, c5s, f4s, f4s, c5s, f4s, f4s, c5s, f4s, d5, f4s};   
float scary_tempo[20]={t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5, t5};

void song2() 
{ 
        for(b=0; b<20; b++) {
            buzzer.beep(scary_freq[b], scary_tempo[b]);
            led2.state(0);
            wait(0.05);
            led2.state(1);
            wait(1/scary_tempo[b]);
            if (x==3){
                led1.state(0);
                led2.state(0);
                buzzer.beep(1000, 0.01);
                break;}    
        }
}
                                                     //Funkcija za detekciju tipke
void pressbutton()
{
        if(debounce.read_ms()>100) {                 //sprečava signalu da titra
        x++;
    }
    debounce.reset();
}


                                                       //Funkcija za blicanje zelene tipke kada je sklop aktivan
void active()
{
    if(x==1 or x==2)
    {
        ledica=!ledica;
    }
    else{
        ledica=0;
        }
}
                                                        //Postavljanje početnog stanja sklopa
int main()
       {
      led1.state(0);
      led2.state(0);
      debounce.start();
      button.rise(&pressbutton);                         // poziva funkciju pressbutton na rastući brid signala tipke
      blink.attach(&active,0.5);                         // blink ticker koji poziva funkciju active u intervalu 0.5
                                                         //while petlja
       while (true) {
                 if(x==1){
                song1();
                }
           else{
                if(x==2){
                song2();
                }
                if(x==3)
                {
                x=0;
                  }
              }
        }
  }