#include "buzzer.h"
#include "mbed.h"

// glavna datoteka

using namespace mbed;


Beep::Beep(PinName pin) : _pwm(pin)
{
    _pwm.write(0.0);                    //početno stanje
}

void Beep::nobeep()
{
    _pwm.write(0.0);
}


void Beep::beep(float freq, float time)         // Definiranje frekvencije u Hz i tranjanje tona u sekundama za jedan zvučni signal
{

    _pwm.period(1.0/freq);               
    _pwm.write(0.5);
    toff.attach(this,&Beep::nobeep, time);
}