#include "mbed.h"
#include "mbed_genie.h"
#include "eeprom_flash.h"
#include "SDFileSystem.h"
#include "ID12RFID.h"

Serial pc(USBTX, USBRX);
ID12RFID rfid(PA_10);

DigitalOut myled(LED1);
DigitalOut led1(PA_8);
DigitalOut led2(PB_14);
DigitalOut led3(PB_11);
DigitalOut led4(PA_11);
DigitalOut led5(PA_12);
DigitalOut led6(PC_5);
DigitalOut led7(PC_6);
DigitalOut led8(PC_8);
DigitalOut ledmasse(PB_3);

int flag_contraste;
int valeur_clavier;
int i;
unsigned int lecture;
int chrono = 99;
int led = 99;
int tab[40] = {1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40};
int code1 = 49;
int code2 = 50;
int code3 = 51;
int y = 15;
int flag = 0;
int adressetempo = 0x0000;
int adresserfid = 0x00000000;
unsigned int tempo1, tempo2, tempo3, tempo4, tempo5, tempo6, tempo7,tempo8, rfid1, rfid2, rfid3, rfid4, rfid5;


void enableEEPROMWriting()
{
    HAL_StatusTypeDef status = HAL_FLASH_Unlock();
    FLASH_PageErase(EEPROM_START_ADDRESS); // required to re-write
    CLEAR_BIT(FLASH->CR, FLASH_CR_PER); // Bug fix: bit PER has been set in Flash_PageErase(), must clear it here
}

void disableEEPROMWriting()
{
    HAL_FLASH_Lock();
}

HAL_StatusTypeDef writeEEPROMWord(uint32_t address, uint32_t data)
{
    HAL_StatusTypeDef status;
    address = address + EEPROM_START_ADDRESS;
    status = HAL_FLASH_Program(FLASH_TYPEPROGRAM_WORD, address, data);
    return status;
}

uint32_t readEEPROMWord(uint32_t address)
{
    uint32_t val = 0;
    address = address + EEPROM_START_ADDRESS;
    val = *(__IO uint32_t*)address;
    return val;
}

void myGenieEventHandler(void)
{
    genieFrame Event;
    genieDequeueEvent(&Event);
    if(Event.reportObject.cmd == GENIE_REPORT_EVENT) 
    {
        if (Event.reportObject.object == GENIE_OBJ_KEYBOARD)
             { 
                if (Event.reportObject.index == 0)
                {
                    valeur_clavier = Event.reportObject.data_lsb;
                    printf("%c\n\r", valeur_clavier);
                    if ((valeur_clavier == code1) || (valeur_clavier== code2) || (valeur_clavier == code3))
                    {
                        printf("Acces autorise\n\r");
                    }
                    else
                    {
                        printf("Acces refuse\n\r");
                    }
                }
             }
        if (Event.reportObject.object == GENIE_OBJ_4DBUTTON)
        {              
            if (Event.reportObject.index == 3) //Start
            {
                printf("Depart\n\r");
                flag=1;
            }
            if (Event.reportObject.index == 5) //Stop
            {
                printf("Stop\n\r");
                flag=0;
            }
            /*if (Event.reportObject.index == 8) // Contraste +
            { 
                if (y<15)
                { 
                 y++;
                 printf("Contraste=%d\r\n",y);
                 flag_contraste=1;
                }
                genieWriteContrast(y);
            }
            if (Event.reportObject.index == 7) // Contraste -
            { 
                if (y>0)
                {
                    y--;
                    printf("Contraste=%d\r\n",y);
                    flag_contraste=1;
                }
                genieWriteContrast(y);
            }*/
            if (Event.reportObject.index == 6) //Lecture tempo
                {
                SDFileSystem sd(PA_7, PA_6, PA_5, PB_6, "sd");
                char numberstring[100];      
                FILE *fp = fopen("/sd/valeur_temporisation.txt", "r");
                fgets(numberstring, 100, fp);  
                    
                if(fp == NULL)
                {
                    error("Impossible d'ouvrir le fichier pour la lecture\n\r");
                    fclose(fp);  
                }
                else
                {
                    printf("Lecture temporisation\n\r");
                    enableEEPROMWriting();
                    sscanf(numberstring, "%d", &tempo1);
                    writeEEPROMWord(adressetempo, tempo1);
                    lecture=readEEPROMWord(adressetempo);
                    printf ("eeprom: %d\n\r",lecture);
                    printf ("carte : %d\n\r",tempo1);
                    sscanf(numberstring+3, "%d", &tempo2);
                    writeEEPROMWord(adressetempo+4, tempo2);
                    lecture=readEEPROMWord(adressetempo+4);
                    printf ("eeprom: %d\n\r",lecture);
                    printf ("carte : %d\n\r",tempo2);
                    sscanf(numberstring+6, "%d", &tempo3);
                    writeEEPROMWord(adressetempo+8, tempo3);
                    lecture=readEEPROMWord(adressetempo+8);
                    printf ("eeprom: %d\n\r",lecture);
                    printf ("carte : %d\n\r",tempo3);
                    sscanf(numberstring+9, "%d", &tempo4);
                    writeEEPROMWord(adressetempo+12, tempo4);
                    lecture=readEEPROMWord(adressetempo+12);
                    printf ("eeprom: %d\n\r",lecture);
                    printf ("carte : %d\n\r",tempo4);
                    sscanf(numberstring+11, "%d", &tempo5);
                    writeEEPROMWord(adressetempo+16, tempo5);
                    lecture=readEEPROMWord(adressetempo+16);
                    printf ("eeprom: %d\n\r",lecture);
                    printf ("carte : %d\n\r",tempo5);
                    sscanf(numberstring+14, "%d", &tempo6);
                    writeEEPROMWord(adressetempo+20, tempo6);
                    lecture=readEEPROMWord(adressetempo+20);
                    printf ("eeprom: %d\n\r",lecture);
                    printf ("carte : %d\n\r",tempo6);
                    sscanf(numberstring+16, "%d", &tempo7);
                    writeEEPROMWord(adressetempo+24, tempo7);
                    lecture=readEEPROMWord(adressetempo+24);
                    printf ("eeprom: %d\n\r",lecture);
                    printf ("carte : %d\n\r",tempo7);
                    sscanf(numberstring+18, "%d", &tempo8);
                    writeEEPROMWord(adressetempo+28, tempo8);
                    lecture=readEEPROMWord(adressetempo+28);
                    printf ("eeprom: %d\n\r",lecture);
                    printf ("carte : %d\n\r",tempo8);
                    fclose(fp);                 
                    printf("Lecture finie!\n\r");
                    disableEEPROMWriting();
                }
                }
            if (Event.reportObject.index == 7) //Lecture code RFID
            {
                SDFileSystem sd(PA_7, PA_6, PA_5, PB_6, "sd");
                char numberrfid[100];
                FILE *fp1 = fopen("/sd/valeur_rfid.txt", "r");
                fgets(numberrfid, 100, fp1);    
                
                if(fp1 == NULL)
                 {
                    error("Impossible d'ouvrir le fichier pour la lecture\n\r");
                }
                flag = 2;
                printf("Lecture code rfid\n\r");
                enableEEPROMWriting();
                sscanf(numberrfid, "%d", &rfid1);
                writeEEPROMWord(adresserfid, rfid1);
                lecture=readEEPROMWord(adresserfid);
                printf ("eeprom: %d\n\r",lecture);
                printf ("carte : %d\n\r", rfid1);
                sscanf(numberrfid+8, "%d", &rfid2);
                writeEEPROMWord(adresserfid+8, rfid2);
                lecture=readEEPROMWord(adresserfid+8);
                printf ("eeprom: %d\n\r",lecture);;
                printf ("carte : %d\n\r", rfid2);
                sscanf(numberrfid+17, "%d", &rfid3);
                writeEEPROMWord(adresserfid+16, rfid3);
                lecture=readEEPROMWord(adresserfid+16);
                printf ("eeprom: %d\n\r",lecture);
                printf ("carte : %d\n\r", rfid3);
                sscanf(numberrfid+25, "%d", &rfid4);
                writeEEPROMWord(adresserfid+24, rfid4);
                lecture=readEEPROMWord(adresserfid+24);
                printf ("eeprom: %d\n\r",lecture);
                printf ("carte : %d\n\r", rfid4);
                sscanf(numberrfid+34, "%d", &rfid5);
                writeEEPROMWord(adresserfid+32, rfid5);
                lecture=readEEPROMWord(adresserfid+32);
                printf ("eeprom: %d\n\r",lecture);
                printf ("carte : %d\n\r", rfid5);
                fclose(fp1); 
                printf("Lecture finie!\n\r");
                disableEEPROMWriting();
                } 
            }
    }
        return; 
}
int main()
{
    pc.baud(9600);
    ledmasse = 1;
    SetupGenie();
    genieAttachEventHandler(&myGenieEventHandler);
    genieWriteContrast(15);
    
    while(1)
    {
        if (flag == 1) 
        {
            led1 = 1;
            led2 = 1;
            led3 = 1;
            led4 = 1;
            led5 = 0;
            led6 = 0;
            led7 = 0;
            led8 = 0;
            wait(1);
            if (chrono == 0)
            {
                chrono=tab[i];
                i=i+1;
            }
        }

        else if(flag == 0)
        {
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 0;
            led5 = 1;
            led6 = 1;
            led7 = 1;
            led8 = 1;
            chrono=tab[i];
            wait(1);
        }
        else if(flag == 2)
        {
            if(rfid.read() == rfid1) 
            {
                printf("RFID Tag number : %d\n\r", rfid.read());
                genieWriteObject(GENIE_OBJ_LED, 0x00, 1); 
            }
        }
        /*if(rfid.read() == rfid1)
            {
                genieWriteObject(GENIE_OBJ_LED, 0x00, chrono); 
            }*/
    }
}