#include "mbed.h"
#include "C12832.h"
#include "MMA7660.h"
#include "LM75B.h"

#define A0  P0_23
#define A1  P0_24
#define A2  P0_25
#define A3  P0_26
#define A4  P0_30
#define A5  P1_31

#define D0  P4_29
#define D1  P4_28
#define D2  P2_13
#define D3  P2_0
#define D4  P2_12
#define D5  P2_1
#define D6  P2_2
#define D7  P2_11

#define D8  P2_4
#define D9  P2_3
#define D10 P1_21
#define D11 P1_24
#define D12 P1_23
#define D13 P1_20
    
#define SDA P0_0
#define SCL P0_1

// Using Arduino pin notation
C12832 lcd(D11, D13, D12, D7, D10);
MMA7660 MMA(SDA,SCL);
LM75B sensor(SDA,SCL);

DigitalOut red_led(D5);
DigitalOut blue_led(D8);
DigitalOut green_led(D9);

AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
AnalogIn right(A5);
DigitalIn fire(D4);

int main()
{

    lcd.cls();

    while(1) {
        lcd.locate(0,0);
        lcd.printf("Temp = %2.1f\n", sensor.read());
        
        lcd.locate(0,11);
        lcd.printf("Acc x=%.2f y=%.2f z=%.2f ",MMA.x(), MMA.y(), MMA.z());

        lcd.locate(0,22);
        lcd.printf("Pot 1 = %.2f  2 = %.2f", (float)pot1, (float)pot2);

        //red_led =  !up && ! fire;
        // blue_led = !down;
        // green_led= !left && !right;
        
        wait(0.2);
    }
}
