//=============================================================================
//  @author vaifreak
//  @brief  Button/Pot utility.
//=============================================================================
#pragma once

//---------------------------------------------
// 
//---------------------------------------------
class MyButton
{
private:
    DigitalIn *d_in;
    
public:
    int val;
    int val_old;
    int trig_on;
    int trig_off;

    MyButton( PinName pin )
    {
        d_in =  new DigitalIn( pin );
    }

    void Update()
    {
        val_old = val;
        val = d_in->read();
        
        trig_on = 0;
        if( val_old == 0 && val == 1 ) trig_on = 1;

        trig_off = 0;
        if( val_old == 1 && val == 0 ) trig_off = 1;
    }

};

//---------------------------------------------
// 
//---------------------------------------------
#define THRESHOLD 0.02f
class MyVolume
{
private:
    AnalogIn *a_in;
    
public:
    float val;
    float val_old;
    bool dirtyFlag;

    MyVolume( PinName pin )
    {
        a_in =  new AnalogIn( pin );
    }

    void Update()
    {
        dirtyFlag = false;
        
        float v = a_in->read();
        if( fabsf(v - val_old) > THRESHOLD )
        {
            val_old = val;
            val = v;
            dirtyFlag = true;
        }
    }

};

