//=============================================================================
//  @author vaifreak
//  @brief  LED level meter class
//=============================================================================
#pragma once

//---------------------------------------------
// 
//---------------------------------------------
class LevelMeter
{
public:
    #define NB_LED 4
    #define BRIGHTNESS 0.2f
    
    LevelMeter()
    {
        led[0] = new PwmOut(LED1);
        led[1] = new PwmOut(LED2);
        led[2] = new PwmOut(LED3);
        led[3] = new PwmOut(LED4);
    }

    // level : [0.0~1.0]
    void Update( float level )
    {
        for(int i=0; i<NB_LED; i++)
        {
            float val;
            val = level - (float)i / (float)NB_LED;
            val = val * (float)NB_LED;
            if( val > 1.0f ) val = 1.0f;
            else if( val < 0.0f ) val = 0.0f;
            led[i]->write( val * BRIGHTNESS );
        }
    }

private:
    PwmOut* led[NB_LED];
    
};
