//=============================================================================
//  @author vaifreak
//  @brief  OverDrive/Distortion unit.
//=============================================================================
#pragma once
#include "Clipper.h"

//---------------------------------------------
// 
//---------------------------------------------
class Drive : public EffectUnitBase
{
private:    
    ClipperBase *clipper_1;
    ClipperBase *clipper_2;
    
public:
    float gain;
    float vol;

    Drive( float g = 2.0f, float v = 1.0f )
    {
        gain = g;
        vol = v;


#if false
        //Asynmmetry clipper
        clipper_1 = new SimpleClipper();
        clipper_2 = new SoftClipper();
#else
        //Synmmetry clipper
        clipper_1 = new SimpleClipper();
        clipper_2 = new SimpleClipper();
#endif
    }        

protected:
    virtual float ProcessConcrete(float input)
    {
        input *= gain;
        
        if(input >= 0.0f)
            return  clipper_1->Process(  input ) * vol; //positive side
        else
            return -clipper_2->Process( -input ) * vol; //negative side
    }    
};