//=============================================================================
//  @author vaifreak
//  @brief  delay unit
//=============================================================================
#pragma once

#define DELAY_BUFF_SIZE 10000

//---------------------------------------------
// 
//---------------------------------------------
class Delay : public EffectUnitBase
{
private:
    unsigned short buff[ DELAY_BUFF_SIZE ];
    int current;
    int offset;
    
    float buff_get( int i ){
        // [0 ~ 65535] to [-1.0 ~ 1.0]
        return ((float)buff[i] * (2.0f/65535.0f) ) - 1.0f;
    }

    void buff_set( int i, float val ){
        // [-1.0 ~ 1.0] to [0 ~ 65535]
        buff[i] = (unsigned short)(((val + 1.0f) * 0.5f) * 65535.0f);
    }
    
public:
    float delay_time; //[0.0~1.0]
    float feedback; //[0.0~1.0]
    float effect_level; 

    Delay()
    {
        for(int i=0; i<DELAY_BUFF_SIZE; i++) buff[i] = 0;

        delay_time = 0.0f;
        feedback = 0.0f;
        effect_level = 0.0f;
        
        current = 0;
    }

    int GetDelayTimeInMSec( float sample_rate )
    {
        return (int)(((float)DELAY_BUFF_SIZE / sample_rate) * delay_time * 1000.0f);
    }
    
protected:
    virtual float ProcessConcrete(float input)
    {
        float output;
        float buff_val = buff_get(current);

        // feedback process.
        offset = current + (int)(delay_time * (float)DELAY_BUFF_SIZE);
        if( offset >= DELAY_BUFF_SIZE ) offset -= DELAY_BUFF_SIZE;
        buff_set( offset, (input + buff_val) * feedback );

        // effect mix.
        output = input + buff_val * effect_level;
        
        current++;
        if(current >= DELAY_BUFF_SIZE) current = 0;
        
        return output;
    }
    
    
};