//=============================================================================
//  @author vaifreak
//  @brief  clipper sub unit ( for Drive )
//=============================================================================
#pragma once

//---------------------------------------------
// Clipper, Base class.
//---------------------------------------------
class ClipperBase
{
public:
    virtual float Process( float samp ) = 0;
};

//---------------------------------------------
// Simple clipper.
//---------------------------------------------
class SimpleClipper : public ClipperBase
{
private:
    float clip;

public:
    SimpleClipper( float c = 0.1f )
    {
        clip = c;
    }
    virtual float Process( float samp )
    {
        if( samp > clip ) {
            return clip;
        } else {
            return samp;
        }
    }
};

//---------------------------------------------
// Simple clipper.
//---------------------------------------------
class SoftClipper : public ClipperBase
{
private:
    float clip;
    float comp_k;

public:
    SoftClipper( float c = 0.05f, float k = 0.01f )
    {
        clip = c;
        comp_k = k;
    }
  
    virtual float Process( float samp )
    {
        if( samp > clip ) {
            return clip + (samp-clip)*comp_k;
        } else {
            return samp;
        }
    }
};

