// WIZ820ioNetIf.cpp 2012/4/17
#include "WIZ820ioNetIf.h"
#include "w5100.h"

extern SPI* pSPI; // w5100.cpp
extern DigitalOut* pCS; // w5100.cpp

DigitalOut* pRESET = NULL;

void hardware_reset() {
  if (!pRESET) {
    pRESET = new DigitalOut(p15);
  }
  if (pRESET) {
    pRESET->write(1);
    pRESET->write(0);
    wait_us(2);
    pRESET->write(1);
    wait_ms(150);
  }
}

bool wait_linkup(int timeout = 5000) {
    Timer link_t;
    link_t.start();
    while(link_t.read_ms() < timeout) {
        if (0x20 & W5100.readPHYSTATUS()) {
            return true;
        }
         wait_ms(50);
    }  
    return false;
}

void WIZ820ioNetIf::spi(PinName mosi,PinName miso, PinName sclk) {
    pSPI = new SPI(mosi,miso,sclk);
}
void WIZ820ioNetIf::cs(PinName _cs) {
    pCS = new DigitalOut(_cs);
}
void WIZ820ioNetIf::reset(PinName _reset) {
    pRESET = new DigitalOut(_reset);
}
    
int WIZ820ioNetIf::setup(int timeout_ms) {
    hardware_reset();
    W5100.init();
    wait_linkup();
    return W5200NetIf::setup(timeout_ms);
}
