// W5200NetIf.h 2012/4/19
/** \file
W5200 network interface header file
*/
#ifndef W5200_NETIF_H
#define W5200_NETIF_H
#include "MyNetIf.h"

///W5200 network interface return codes
enum W5200Err
{
  __W5200_MIN = -0xFFFF,
  W5200_TIMEOUT, ///<Timeout during setup
  W5200_OK = 0 ///<Success
};

///W5200 network interface
class W5200NetIf : public MyNetIf {
public:
    ///Instantiates the Interface and register it against the stack, DHCP will be used
    W5200NetIf(); //W/ DHCP
    ///Instantiates the Interface and register it against the stack, DHCP will not be used
    /**
    IpAddr is a container class that can be constructed with either 4 bytes or no parameters for a null IP address.
    */
    W5200NetIf(IpAddr ip, IpAddr netmask, IpAddr gateway, IpAddr dns); //W/o DHCP
    W5200Err IPrenew(int timeout_ms = 15000);
    W5200Err IPrelease(int timeout_ms = 15000);
    ///Brings the interface up
    /**
    Uses DHCP if necessary
    @param timeout_ms : You can set the timeout parameter in milliseconds, if not it defaults to 15s
    @return : W5200_OK on success or W5200_TIMEOUT on timeout
    */
    W5200Err setup(int timeout_ms = 15000);
    IpAddr m_dns;
private:
    bool m_useDhcp;
    IpAddr m_netmask;
    IpAddr m_gateway;
    const char* m_hostname;
};
#endif //W5200_NETIF_H
