// W5200NetIf.cpp 2012/4/13
#include "W5200NetIf.h"
#include "DHCPClient.h"
#include "w5100.h"

W5200NetIf:: W5200NetIf():MyNetIf(), m_netmask(255,255,255,255), m_gateway(), m_hostname(NULL) {
    m_hostname = NULL;
    m_useDhcp = true;
}

W5200NetIf::W5200NetIf(IpAddr ip, IpAddr netmask, IpAddr gateway, IpAddr dns) :MyNetIf(), m_hostname(NULL) {
    m_hostname = NULL;
    m_ip = ip;
    m_netmask = netmask;
    m_gateway = gateway;
    m_dns = dns;
    m_useDhcp = false;
}

W5200Err W5200NetIf::IPrenew(int timeout_ms) {
    printf("DHCP Started, waiting for IP...\n");  
    DHCPClient dhcp;
    int err = dhcp.setup(timeout_ms);
    if (err == (-1)) {
        printf("Timeout.\n");
        return W5200_TIMEOUT;
    }
    printf("Connected, IP: %d.%d.%d.%d\n", dhcp.yiaddr[0], dhcp.yiaddr[1], dhcp.yiaddr[2], dhcp.yiaddr[3]);
    m_ip = IpAddr(dhcp.yiaddr[0], dhcp.yiaddr[1], dhcp.yiaddr[2], dhcp.yiaddr[3]);
    m_netmask = IpAddr(dhcp.netmask[0],dhcp.netmask[1],dhcp.netmask[2],dhcp.netmask[3]);
    m_gateway = IpAddr(dhcp.gateway[0],dhcp.gateway[1],dhcp.gateway[2],dhcp.gateway[3]);
    uint8_t t[4];
    t[0] = m_ip[0];
    t[1] = m_ip[1];
    t[2] = m_ip[2];
    t[3] = m_ip[3];
    W5100.writeSIPR(t);
    t[0] = m_netmask[0];
    t[1] = m_netmask[1];
    t[2] = m_netmask[2];
    t[3] = m_netmask[3];
    W5100.writeSUBR(t);
    t[0] = m_gateway[0];
    t[1] = m_gateway[1];
    t[2] = m_gateway[2];
    t[3] = m_gateway[3];
    W5100.writeGAR(t);
    m_dns = IpAddr(dhcp.dnsaddr[0],dhcp.dnsaddr[1],dhcp.dnsaddr[2],dhcp.dnsaddr[3]);
    return W5200_OK;
}

W5200Err W5200NetIf::IPrelease(int timeout_ms) {
    return W5200_OK;
}

W5200Err W5200NetIf::setup(int timeout_ms) {
    MyNetIf::init();
    uint8_t mac[6] = {0x00,0x00,0x5e,0x00,0x01,0x01};
    W5100.setMACAddress(mac);
    printf("HW Addr is : %02x:%02x:%02x:%02x:%02x:%02x.\n", mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]);
    if(! m_useDhcp) {
        return W5200_OK;
    }
    return IPrenew(timeout_ms);
}
