// DHCPClient.h 2012/4/13
#ifndef DHCPCLIENT_H
#define DHCPCLIENT_H
#include "UDPSocket.h"


#define DHCP_OFFSET_OP 0
#define DHCP_OFFSET_XID 4
#define DHCP_OFFSET_YIADDR 16
#define DHCP_OFFSET_CHADDR 28
#define DHCP_OFFSET_MAGIC_COOKIE 236
#define DHCP_OFFSET_OPTIONS 240
#define DHCP_MAX_PACKET_SIZE 600

class DHCPClient {
    int discover(uint8_t buf[], int size);
    int request(uint8_t buf[], int size);
    int offer_ack(uint8_t buf[], int size);
    bool verify(uint8_t buf[], int len);
public:
    void callback(UDPSocketEvent e);
    int setup(int timeout_ms = 15000);
    DHCPClient();
    uint8_t chaddr[6]; // MAC
    uint8_t yiaddr[4]; // IP
    uint8_t dnsaddr[4]; // DNS
    uint8_t gateway[4];
    uint8_t netmask[4];
private:
    UDPSocket* m_udp;
    uint8_t xid[4];
    bool exit_flag;
};
#endif //DHCPCLIENT_H
