#ifndef UVC_H
#define UVC_H
#include "UsbBaseClass.h"
#include "usb_mem.h"
#include "usb_mjpeg.h"

#define CLASS_VIDEO 0x0E

#define SET_CUR  0x01
#define GET_CUR  0x81
#define GET_MIN  0x82
#define GET_MAX  0x83
#define GET_RES  0x84
#define GET_LEN  0x85
#define GET_INFO 0x86
#define GET_DEF  0x87

#define VS_PROBE_CONTROL  0x01
#define VS_COMMIT_CONTROL 0x02

#define PAYLOAD_UNDEF 0
#define PAYLOAD_MJPEG 1
#define PAYLOAD_YUY2  2

class uvc : public UsbBaseClass {
public:
    uvc(int cam = 0);
    ~uvc();
    int setup();
    int get_jpeg(const char* path);
    int get_jpeg(uint8_t* buf, int size);
    bool interrupt();
    int isochronous();
    void attach(usb_stream* stream);
    void detach();
    ///set format index
    void SetFormatIndex(int index = 1);
    ///set frame index
    void SetFrameIndex(int index = 1);
    ///set frame interval
    void SetFrameInterval(int val = 2000000);
    ///set packet size
    void SetPacketSize(int size = 128);
    ///set image size
    void SetImageSize(int width = 160, int height = 120);
    ///set payload MJPEG or YUY2
    void SetPayload(int payload); // MJPEG,YUV422(YUY2)
    UsbErr Control(int req, int cs, int index, uint8_t* buf, int size);
    ///Setups the result callback
    /**
     @param pMethod : callback function
     */
    void setOnResult( void (*pMethod)(uint16_t, uint8_t*, int) );
  
    ///Setups the result callback
    /**
    @param pItem : instance of class on which to execute the callback method
    @param pMethod : callback method
    */
    class CDummy;
    template<class T> 
    void setOnResult( T* pItem, void (T::*pMethod)(uint16_t, uint8_t*, int) )
    {
        m_pCb = NULL;
        m_pCbItem = (CDummy*) pItem;
        m_pCbMeth = (void (CDummy::*)(uint16_t, uint8_t*, int)) pMethod;
    }
    void clearOnResult();

    void poll();
    void wait(float s);
    void wait_ms(int ms);
    uint16_t ReportConditionCode[16];
protected:
    int _init();
    void _config(struct stcamcfg* cfg);
    void probe_commit_control(struct stcamcfg* cfg);
    void onResult(uint16_t frame, uint8_t* buf, int len);
    bool m_connect;
    bool m_init;
    int m_cam;
    UsbDevice* m_pDev;
    UsbEndpoint* m_pEpIntIn;
    UsbEndpoint* m_pEpIsoIn;
    int m_width;
    int m_height;
    int m_payload;
    int m_FormatIndex;
    int m_FrameIndex;
    int m_FrameInterval;
    int m_PacketSize;
    int m_FrameCount; // 1-8
    int m_itdCount;
    uint8_t m_int_buf[16];
    int m_int_seq;
    int m_iso_seq;
    uint16_t m_iso_frame;
    usb_stream* m_stream;
    CDummy* m_pCbItem;
    void (CDummy::*m_pCbMeth)(uint16_t, uint8_t*, int);
    void (*m_pCb)(uint16_t, uint8_t*, int);
};
#endif //UVC_H