/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef ARGUMENTS_H
#define ARGUMENTS_H

#include "platform.h"

namespace mbed {

#define RPC_MAX_STRING  128
#define RPC_MAX_ARGS     16

class Arguments {
public:
    Arguments(const char* rqs);
    
    template<typename Arg>
    Arg   getArg(void);
    
    char *obj_name;
    char *method_name;
    
    int   argc;
    char* argv[RPC_MAX_ARGS];

private:
    // This copy can be removed if we can assume the request string is
    // persistent and writable for the duration of the call
    char  request[RPC_MAX_STRING];
    int index;
    char* search_arg(char **arg, char *p, char next_sep);
};

class Reply {
public:
    Reply(char* r);
    
    template<typename Data>
    void putData(Data d);

private:
    void separator(void);
    bool first;
    char* reply;
};


} // Namespace mbed

#endif
