// Semihost.h 2014/5/3
#pragma once
#include "Target2.h"
#include "USBLocalFileSystem.h"
#include "mydebug.h"

/** Semihosting
 */
class Semihost {
public:
    Semihost(Target2* target, Serial* usbpc, USBLocalFileSystem* usb);
    void mount(const char* dirpath);
    int poll();
    enum Reason {
        SYS_NONE = 0,
        SYS_EXIT = 0x18,
    };
    int readable();
    int getc();

private:
    int exec(uint32_t reason, uint32_t arg);
    
    int sys_open(uint32_t arg);   // 0x01
    int sys_close(uint32_t arg);  // 0x02
    int sys_writec(uint32_t arg); // 0x03
    int sys_write0(uint32_t arg); // 0x04
    int sys_write(uint32_t arg);  // 0x05
    int sys_read(uint32_t arg);   // 0x06
    int sys_readc(uint32_t arg);  // 0x07
    int sys_istty(uint32_t arg);  // 0x09
    int sys_fseek(uint32_t arg);  // 0x0a
    int sys_ensure(uint32_t arg); // 0x0b
    int sys_flen(uint32_t arg);   // 0x0c
    int sys_remove(uint32_t arg); // 0x0e
    int sys_rename(uint32_t arg); // 0x0f
    int sys_exit(uint32_t arg);   // 0x18

    int usr_xffind(uint32_t arg);      // 0x100
    int usr_uid(uint32_t arg);         // 0x101
    int usr_reset(uint32_t arg);       // 0x102
    int usr_vbus(uint32_t arg);        // 0x103
    int usr_powerdown(uint32_t arg);   // 0x104
    int usr_disabledebug(uint32_t arg);// 0x105
    
    void _build_name(char* buf, int size, uint32_t arg1, uint32_t arg2);

    template<typename T>
    void wr(uint32_t addr, T data) {
        TEST_ASSERT(addr <= 0x10001fff);
        for(int i = 0; i < sizeof(T); i++) {
            _target->writeMemory8(addr+i, data);
            data >>= 8;
        }
    }

    template<typename T>
    T rd(uint32_t addr) {
        TEST_ASSERT(addr <= 0x10001fff);
        T data = 0;
        for(int i = sizeof(T)-1; i >= 0; i--) {
            data <<= 8;
            data |= _target->readMemory8(addr+i);
        }
        return data;
    }
 
protected:
    Target2* _target;
    Serial* _pc;
    USBLocalFileSystem* _usb;
    char* _dirpath;
    int _writec_buf;
};
