// test_Semihost.cpp 2013/9/14
#if 0
#include "Semihost.h"
#include "Flash.h"
#include "mytest.h"

LocalFileSystem local("local");
Serial pc(USBTX, USBRX);
Target2 target(p21,p22,p17); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
Serial target_uart(p9,p10); // RXD(dp15),TXD(dp16)

Semihost* sh;

TEST(Target2,setup) {
    ASSERT_TRUE(target.setup());
    target.halt();
    target.wait_status(TARGET_HALTED);
}

#define RAM 0x10000000

TEST(Target2,readMemory8_1) {
    target.writeMemory(RAM, 0x12345678);
    ASSERT_TRUE(0x12345678 == target.readMemory(RAM));
    
    ASSERT_TRUE(0x78 == target.readMemory8(RAM));
    ASSERT_TRUE(0x56 == target.readMemory8(RAM+1));
    ASSERT_TRUE(0x34 == target.readMemory8(RAM+2));
    ASSERT_TRUE(0x12 == target.readMemory8(RAM+3));
}

TEST(Target2,writeMemory8_1) {
    target.writeMemory(RAM, 0xfefefefe);
    ASSERT_TRUE(0xfefefefe == target.readMemory(RAM));
    
    target.writeMemory8(RAM, 0x78);
    ASSERT_TRUE(0xfefefe78 == target.readMemory(RAM));
    
    target.writeMemory8(RAM+1, 0x56);
    ASSERT_TRUE(0xfefe5678 == target.readMemory(RAM));
       
    target.writeMemory8(RAM+2, 0x34);
    ASSERT_TRUE(0xfe345678 == target.readMemory(RAM));

    target.writeMemory8(RAM+3, 0x12);
    ASSERT_TRUE(0x12345678 == target.readMemory(RAM));
}

#if 1
TEST(Flash1,flash1) {
    Flash flash(&target, &pc);
    bool r = flash.init();
    ASSERT_TRUE(r);
    r = flash.eraseAll();
    ASSERT_TRUE(r);
    r = flash.write("/local/SEMIHOST.LPC");
    ASSERT_TRUE(r);
}
#endif

TEST(Semihost1,poll) {
    target.SoftwareReset();
    target.setup();
    sh = new Semihost(&target, &pc);
    sh->mount("/local");
    Timer t;
    t.reset();
    t.start();
    while(t.read_ms() < 1000*15) {
        if (target_uart.readable()) {
            pc.putc(target_uart.getc());
        }
        if (sh->poll() == Semihost::SYS_EXIT) {
            break;
        }
    }
}

int main() {
    pc.baud(921600);
    //pc.baud(9600);
    DBG("%s", __FILE__);

    RUN_ALL_TESTS();
    exit(0);
}
#endif
