// test2_BaseDAP.cpp 2013/9/13
#if 0
#include "BaseDAP.h"
#include "USBDAP.h"
#include "mytest.h"
#include "mydebug.h"

Serial pc(USBTX, USBRX);

#ifdef TARGET_LPC1768
SWD swd(p21,p22,p17); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
DigitalOut connected(LED1);
DigitalOut running(LED2);
class myDAP : public BaseDAP {
public:
    myDAP(SWD* swd):BaseDAP(swd){};
    virtual void infoLED(int select, int value) {
        switch(select) {
            case 0: connected = value; break;
            case 1: running = value; break;
        }
    } 
};
#endif

#ifdef TARGET_KL25Z
SWD swd(PTB8,PTB9,PTB10); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
DigitalOut connected(LED_GREEN);
DigitalOut running(LED_RED);
class myDAP : public BaseDAP {
public:
    myDAP(SWD* swd):BaseDAP(swd){};
    virtual void infoLED(int select, int value) {
        switch(select) {
            case 0:
                connected = value^1; 
                running = 1;
                break;
            case 1: 
                running = value^1; 
                connected = 1;
                break;
        }
    } 
};
#endif

myDAP* dap = NULL;
USBDAP* hid = NULL;

HID_REPORT send_report;
HID_REPORT recv_report;

TEST(DAP2,setup2) {
    dap = new myDAP(&swd);
}

TEST(DAP2,setup3) {
    hid = new USBDAP(64, 64, 0x0d28, 0x0204);
}

TEST(DAP2,test1) {
    ASSERT_TRUE(hid);
    ASSERT_TRUE(dap);
    if(hid->readNB(&recv_report)) {
        dap->Command(recv_report.data, send_report.data);
        send_report.length = 64;
        hid->send(&send_report);
    }
}

static void hex_dump(uint8_t* buf, int size)
{
    for(int i = 0; i < size; i++) {
        printf("%02x ", buf[i]);
    }
    printf("\n");
}

TEST(DAP2,forever1) {
    while(1) {
        if(hid->readNB(&recv_report)) {
            //DBG("%02x", recv_report.data[0]);
            hex_dump(recv_report.data, 32);
            uint8_t cmd = recv_report.data[0];
            dap->Command(recv_report.data, send_report.data);
            send_report.length = 64;
            uint8_t* buf = send_report.data;
            DBG("%02x: %02x %02x %02x %02x %02x", cmd, buf[0], buf[1], buf[2], buf[3], buf[4]); 
            bool r = hid->send(&send_report);
            ASSERT_TRUE(r);
        }
    }    
}

int main() {
    pc.baud(921600);
    //pc.baud(9600);
    DBG("%s", __FILE__);

    RUN_ALL_TESTS();
    exit(0);
}
#endif
