// test1_SWD.cpp 2013/9/14
#if 0
#include "SWD.h"
#include "mytest.h"

Serial pc(USBTX, USBRX);
#ifdef TARGET_LPC1768
SWD swd(p21,p22,p17); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
#endif
#ifdef TARGET_KL25Z
SWD swd(PTB8,PTB9,PTB10); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
#endif 


TEST(SWD1,setup) {
    swd.Setup();
}

TEST(SWD1,JTAG2SWD) {
    const uint8_t data1[] = {0xff,0xff,0xff,0xff,0xff,0xff,0xff};
    const uint8_t data2[] = {0x9e,0xe7};
    const uint8_t data3[] = {0x00};
    swd.SWJSequence(sizeof(data1)*8, data1);
    swd.SWJSequence(sizeof(data2)*8, data2);
    swd.SWJSequence(sizeof(data1)*8, data1);
    swd.SWJSequence(sizeof(data3)*8, data3);
}

TEST(SWD1,idcode) {
    uint32_t data = 0xffffffff;
    uint8_t ack = swd.Transfer(DP_IDCODE, &data);
    ASSERT_TRUE(ack == SWD_OK);
    ASSERT_TRUE(data == 0x0bb11477);
}

TEST(SWD1,abort1) {
    uint32_t data = 0x1e;
    uint8_t ack = swd.Transfer(DP_ABORT, &data);
    ASSERT_TRUE(ack == SWD_OK);
}

TEST(SWD1,select) {
    uint32_t data = 0x0;
    uint8_t ack = swd.Transfer(DP_SELECT, &data);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("DP_RDBUFF: %08x\n", data);
}

TEST(SWD1,ctrl_stat) {
    uint32_t data = CSYSPWRUPREQ | CDBGPWRUPREQ;
    ASSERT_TRUE(data == 0x50000000);
    uint8_t ack = swd.Transfer(DP_CTRL_STAT, &data);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("DP_RDBUFF: %08x\n", data);

    ack = swd.Transfer(DP_CTRL_STAT_R, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("%08x\n", data);
    ASSERT_TRUE(data == 0xf0000040);
}

TEST(SWD1,abort2) {
    uint32_t data = 0x1e;
    uint8_t ack = swd.Transfer(DP_ABORT, &data);
    ASSERT_TRUE(ack == SWD_OK);
}

TEST(SWD1,ctrl_stat1) {
    //uint32_t data = CSYSPWRUPREQ | CDBGPWRUPREQ | TRNNORMAL;
    uint32_t data = CSYSPWRUPREQ | CDBGPWRUPREQ | 0x04000000;
    ASSERT_TRUE(data == 0x54000000);
    uint8_t ack = swd.Transfer(DP_CTRL_STAT, &data);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("DP_RDBUFF: %08x\n", data);
}

TEST(SWD1,ctrl_stat2) {
    uint32_t data = CSYSPWRUPREQ | CDBGPWRUPREQ | MASKLANE;
    ASSERT_TRUE(data == 0x50000f00);
    uint8_t ack = swd.Transfer(DP_CTRL_STAT, &data);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("DP_RDBUFF: %08x\n", data);
}

TEST(SWD1,csw) {
    uint32_t data = CSW_VALUE|CSW_SIZE32;
    ASSERT_TRUE(data == 0x23000052);
    uint8_t ack = swd.Transfer(AP_CSW, &data);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, &data);
    DBG("ack=%02x\n", ack);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("DP_RDBUFF: %08x\n", data);
}

TEST(SWD1,tar) {
    //uint32_t addr = 0x10000000;
    uint32_t addr = 0x00000000;
    uint8_t ack = swd.Transfer(AP_TAR, &addr);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, NULL);
    ASSERT_TRUE(ack == SWD_OK);
}

TEST(SWD1,drw) {
    uint32_t data = 0xffffffff;
    uint8_t ack = swd.Transfer(AP_DRW_R, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("data=%08x\n", data);

    ack = swd.Transfer(AP_DRW_R, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("data=%08x\n", data);

    ack = swd.Transfer(AP_DRW_R, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("data=%08x\n", data);

    ack = swd.Transfer(DP_RDBUFF, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("data=%08x\n", data);
}

TEST(SWD1,MemoryRead) {
    uint32_t addr = 0;
    uint32_t data = 0xffffffff;
    uint32_t dummy = 0xffffffff;
    
    uint8_t ack = swd.Transfer(AP_TAR, &addr);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, NULL);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(AP_DRW_R, &dummy);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("dummy=%08x\n", dummy);

    ack = swd.Transfer(DP_RDBUFF, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("addr=%08x data=%08x\n", addr, data);
}

TEST(SWD1,DHCSR) {
    uint32_t addr = 0xE000EDF0; // Debug Halting Control and Status Register
    uint32_t data = 0xffffffff;
    uint32_t dummy = 0xffffffff;
    
    uint8_t ack = swd.Transfer(AP_TAR, &addr);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, NULL);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(AP_DRW_R, &dummy);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("dummy=%08x\n", dummy);

    ack = swd.Transfer(DP_RDBUFF, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("addr=%08x data=%08x\n", addr, data);
}

TEST(SWD1,MemoryRead_fault) {
    uint32_t addr = 10000000;
    uint32_t data = 0xffffffff;
    uint32_t dummy = 0xffffffff;
    
    uint8_t ack = swd.Transfer(AP_TAR, &addr);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, NULL);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(AP_DRW_R, &dummy);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, &data);
    ASSERT_TRUE(ack == SWD_FAULT);
}

TEST(SWD1,abort3) {
    uint32_t data = 0x1e;
    uint8_t ack = swd.Transfer(DP_ABORT, &data);
    ASSERT_TRUE(ack == SWD_OK);
}

TEST(SWD1,DCRSR) {
    uint32_t addr = 0xE000EDF4; // Debug Core Register Selector Register 
    uint32_t data = 0xffffffff;
    uint32_t dummy = 0xffffffff;
    
    uint8_t ack = swd.Transfer(AP_TAR, &addr);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(DP_RDBUFF, NULL);
    ASSERT_TRUE(ack == SWD_OK);

    ack = swd.Transfer(AP_DRW_R, &dummy);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("dummy=%08x\n", dummy);

    ack = swd.Transfer(DP_RDBUFF, &data);
    ASSERT_TRUE(ack == SWD_OK);
    DBG("addr=%08x data=%08x\n", addr, data);
}

int main() {
    //pc.baud(921600);
    pc.baud(9600);
    DBG("%s", __FILE__);

    RUN_ALL_TESTS();
}
#endif
