// test_Flash.cpp 2013/9/5
#if 0
#include "Target2.h"
#include "Flash.h"
#include "mytest.h"

LocalFileSystem local("local");
Serial pc(USBTX, USBRX);
Target2* target;
Flash* flash;
const char* filename = "/local/1114FN28.LPC";

#define SKIP_FLASH_WRITE 1

TEST(IAP1,cmd55_read_boot_code_version) {
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::READ_BOOT_CODE_VERSION);
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);
    for(uint32_t addr = 0x10000100; addr < 0x10000100+44; addr += 4) {
        TEST_PRINT("%08x: %08x", addr, target->readMemory(addr));
    }
}

TEST(IAP1,cmd54) {
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::READ_PART_ID);
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);
    for(uint32_t addr = 0x10000100; addr < 0x10000100+44; addr += 4) {
        TEST_PRINT("%08x: %08x", addr, target->readMemory(addr));
    }
}

TEST(IAP1,cmd58_ReadUID) {
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::READ_UID);
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);
    for(uint32_t addr = 0x10000100; addr < 0x10000100+44; addr += 4) {
        TEST_PRINT("%08x: %08x", addr, target->readMemory(addr));
    }
}

TEST(IAP1,cmd50_prepare_sector7) {
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::PREPARE_SECTOR,7,7);
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);
}

TEST(IAP1,cmd50_prepare_sector6) {
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::PREPARE_SECTOR,6,6);
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);
}

TEST(IAP1,prepare_status_7) {
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::PREPARE_SECTOR,8,8);
    ASSERT_TRUE(status_code == Flash::INVALID_SECTOR);

    status_code = flash->remoteIAP(Flash::PREPARE_SECTOR,9,9);
    ASSERT_TRUE(status_code == Flash::INVALID_SECTOR);
}

TEST(IAP1,compare_status_10) {
    uint32_t buf[16];
    uint32_t ram  = 0x10000000;
    uint32_t addr = 0x00001000;
    target->readMemory(addr, buf, sizeof(buf)/sizeof(uint32_t));
    target->writeMemory(ram, buf, sizeof(buf)/sizeof(uint32_t));

    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::COMPARE, ram, addr);
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);
  
    status_code = flash->remoteIAP(Flash::COMPARE, ram, addr+1, sizeof(buf));
    ASSERT_TRUE(status_code == Flash::ADDR_ERROR);

    status_code = flash->remoteIAP(Flash::COMPARE, ram+1, addr, sizeof(buf));
    ASSERT_TRUE(status_code == Flash::ADDR_ERROR);

    status_code = flash->remoteIAP(Flash::COMPARE, ram, addr, sizeof(buf)-1);
    ASSERT_TRUE(status_code == Flash::COUNT_ERROR);

    status_code = flash->remoteIAP(Flash::COMPARE, ram+4, addr, sizeof(buf));
    ASSERT_TRUE(status_code == Flash::COMPARE_ERROR);
}

#ifndef SKIP_FLASH_WRITE
TEST(IAP1,cmd52_erase_sector7) {
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::PREPARE_SECTOR, 7, 7);
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);

    status_code = flash->remoteIAP(Flash::ERASE_SECTOR, 7, 7, 12000); // CCLK=12MHz
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);
}

TEST(IAP1,cmd53_blank_check_sector7) {
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::PREPARE_SECTOR, 7, 7);
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);
    status_code = flash->remoteIAP(Flash::ERASE_SECTOR, 7, 7, 12000); // CCLK=12MHz
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);

    status_code = flash->remoteIAP(Flash::BLANK_CHECK, 7, 7, 12000); // CCLK=12MHz
    ASSERT_TRUE(status_code == Flash::CMD_SUCCESS);
}

TEST(IAP1,cmd51_copy_ram_to_flash_sector7) {
    uint32_t src = 0x10000200;

    uint8_t buf[256];
    for(int i = 0; i < sizeof(buf); i++) {
        buf[i] = i & 0xff;
    }
    target->writeMemory(src, (uint32_t*)buf, sizeof(buf)/sizeof(uint32_t));

    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::PREPARE_SECTOR, 7, 7); // prepare
    ASSERT_TRUE(status_code == 0);
    uint32_t dst = 4096*7;
    status_code = flash->remoteIAP(Flash::COPY_RAM_TO_FLASH, dst, src, 256, 12000); // CCLK=12MHz
    ASSERT_TRUE(status_code == 0);
}

TEST(IAP1,cmd56_compare1) {
    uint32_t dst = 4096*7;
    uint32_t src = 0x10000200;
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::COMPARE, dst, src, 256);
    ASSERT_TRUE(status_code == 0);
}

TEST(IAP1,cmd56_compare2) {
    uint32_t dst = 4096*7;
    uint32_t src = 0x10000200+4;
    Flash::IAP_STATUS status_code = flash->remoteIAP(Flash::COMPARE, dst, src, 256);
    ASSERT_TRUE(status_code != 0);
}

TEST(Flash1,verify0) {
    bool st = flash->verify("/local/1114FN28.LPC");
    ASSERT_TRUE(st);
}

TEST(Flash1,eraseAll) {
    bool st = flash->eraseAll();
    ASSERT_TRUE(st);
}

TEST(Flash1,write1) {
    bool st = flash->write("/usb/1114FN28.LPC");
    ASSERT_TRUE(!st);
}

TEST(Flash1,write2) {
    bool st = flash->write("/local/1114FN28.LPC");
    ASSERT_TRUE(st);
}

TEST(Flash1,verify1) {
    bool st = flash->verify("/usb/1114FN28.LPC");
    ASSERT_TRUE(!st);
}

TEST(Flash1,verify2) {
    bool st = flash->verify("/local/1114FN28.LPC");
    ASSERT_TRUE(st);
}

TEST(Flash1,verify3) {
    bool st = flash->verify("/local/1114FN28.LPC");
    ASSERT_TRUE(st);
}

#endif

int main() {
    pc.baud(921600);
    DBG("%s", __FILE__);

    target = new Target2(p21,p22,p17); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
    target->setup();
    flash = new Flash(target, &pc);

    RUN_ALL_TESTS();
}
#endif
