// test1_BaseDAP.cpp 2013/9/14
#if 0
#include "BaseDAP.h"
#include "mytest.h"
#include "mydebug.h"

Serial pc(USBTX, USBRX);

SWD* swd;
BaseDAP* dap;
uint8_t recv[64];

TEST(DAP1,setup) {
#ifdef TARGET_LPC1768
    swd = new SWD(p21,p22,p17); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
#endif
#ifdef TARGET_KL25Z
    swd = new SWD(PTB8,PTB9,PTB10); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
#endif
    dap = new BaseDAP(swd);
}

TEST(DAP1,Info_PRODUCT) {
    const uint8_t req[] = {0x00,0x02};
    const uint8_t res[] = {0x00,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Info_SER_NUM) {
    const uint8_t req[] = {0x00,0x03};
    const uint8_t res[] = {0x00,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Info_FW_VER) {
    const uint8_t req[] = {0x00,0x04};
    const uint8_t res[] = {0x00,0x04,0x31,0x2e,0x30,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Info_VENDOR) {
    const uint8_t req[] = {0x00,0x01};
    const uint8_t res[] = {0x00,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Info_PRODUCT_2) {
    const uint8_t req[] = {0x00,0x02};
    const uint8_t res[] = {0x00,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Info_PACKET_SIZE) {
    const uint8_t req[] = {0x00,0xff};
    const uint8_t res[] = {0x00,0x02,0x40,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Info_PACKET_COUNT) {
    const uint8_t req[] = {0x00,0xfe};
    const uint8_t res[] = {0x00,0x01,0x01};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Connect_SWD) {
    const uint8_t req[] = {0x02,0x01};
    const uint8_t res[] = {0x02,0x01};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,SWJ_Clock_5000_Hz) {
    const uint8_t req[] = {0x11,0x88,0x13,0x00,0x00};
    const uint8_t res[] = {0x11,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,TransferConfigure) {
    const uint8_t req[] = {0x04,0x00,0x64,0x00,0x00,0x00};
    const uint8_t res[] = {0x04,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,SWD_Configure) {
    const uint8_t req[] = {0x13,0x00};
    const uint8_t res[] = {0x13,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,LED_DEBUGGER_CONNECTED_ON) {
    const uint8_t req[] = {0x01,0x00,0x01};
    const uint8_t res[] = {0x01,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,SWJ_Sequence_1_51) {
    const uint8_t req[] = {0x12,0x33, 0xff,0xff,0xff,0xff,0xff,0xff,0xff};
    const uint8_t res[] = {0x12,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,SWJ_Sequence_2_16) {
    const uint8_t req[] = {0x12,0x10, 0x9e,0xe7};
    const uint8_t res[] = {0x12,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,SWJ_Sequence_3_51) {
    const uint8_t req[] = {0x12,0x33, 0xff,0xff,0xff,0xff,0xff,0xff,0xff};
    const uint8_t res[] = {0x12,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,SWJ_Sequence_4_8) {
    const uint8_t req[] = {0x12,0x08, 0x00};
    const uint8_t res[] = {0x12,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Transfer_DP_IDCODE) {
    const uint8_t req[] = {0x05, 0x00, 0x01, 0x02};
    const uint8_t res[] = {0x05, 0x01, 0x01, 0x77,0x14,0xb1,0x0b};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    DBG_HEX(recv, len);
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Transfer_DP_SELECT) {
    const uint8_t req[] = {0x05, 0x00, 0x01, 0x08, 0x00,0x00,0x00,0x00};
    //SWD: DP_SELECT 00000000 request=08(DP nW 8) wdata=00000000 rdata=00000000 ack=01
    //SWD: DP_RDBUFF 10008000 request=0e(DP R c) wdata=ffffffff rdata=10008000 ack=01
    const uint8_t res[] = {0x05, 0x01, 0x01};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Transfer_DP_CTRL_STAT_W) {
    const uint8_t req[] = {0x05,0x00, 0x01, 0x04, 0x00,0x00,0x00,0x50};
    //SWD: DP_CTRL_STAT W 50000000 request=04(DP nW 4) wdata=50000000 rdata=50000000 ack=01
    //SWD: DP_RDBUFF 10008000 request=0e(DP R c) wdata=ffffffff rdata=10008000 ack=01
    const uint8_t res[] = {0x05,0x01, 0x01};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Transfer_DP_CTRL_STAT_R) {
    const uint8_t req[] = {0x05,0x00, 0x01, 0x06};
    //SWD: DP_CTRL_STAT R f0000040 request=06(DP R 4) wdata=00000040 rdata=f0000040 ack=01
    const uint8_t res[] = {0x05,0x01, 0x01, 0x40,0x00,0x00,0xf0};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,WriteABORT) {
    const uint8_t req[] = {0x08,0x00,0x1e,0x00,0x00,0x00};
    //SWD: DP_ABORT 0000001e request=00(DP nW 0) wdata=0000001e rdata=0000001e ack=01
    const uint8_t res[] = {0x08,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Transfer_DP_CTRL_STAT_W_2) {
    const uint8_t req[] = {0x05,0x00, 0x01, 0x04, 0x00,0x00,0x00,0x54};
    //SWD: DP_CTRL_STAT W 54000000 request=04(DP nW 4) wdata=54000000 rdata=54000000 ack=01
    //SWD: DP_RDBUFF 10008000 request=0e(DP R c) wdata=ffffffff rdata=10008000 ack=01
    const uint8_t res[] = {0x05,0x01, 0x01};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Transfer_DP_CTRL_STAT_W_3) {
    const uint8_t req[] = {0x05,0x00, 0x01, 0x04, 0x00,0x0f,0x00,0x50};
    //SWD: DP_CTRL_STAT W 50000f00 request=04(DP nW 4) wdata=50000f00 rdata=50000f00 ack=01
    //SWD: DP_RDBUFF 10008000 request=0e(DP R c) wdata=ffffffff rdata=10008000 ack=01
    const uint8_t res[] = {0x05,0x01, 0x01};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Transfer_AP_CSW) {
    const uint8_t req[] = {0x05,0x00, 0x01, 0x01, 0x52,0x00,0x00,0x23};
    //SWD: AP_CSW W 23000052 request=01(AP nW 0) wdata=23000052 rdata=23000052 ack=01
    //SWD: DP_RDBUFF 10008000 request=0e(DP R c) wdata=ffffffff rdata=10008000 ack=01
    const uint8_t res[] = {0x05,0x01, 0x01};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Transfer_AP_TAR) {
    const uint8_t req[] = {0x05,0x00, 0x01, 0x05, 0xf0,0xff,0x0f,0xe0};
    //SWD: AP_TAR W e00ffff0 request=05(AP nW 4) wdata=e00ffff0 rdata=e00ffff0 ack=01
    //SWD: DP_RDBUFF 10008000 request=0e(DP R c) wdata=ffffffff rdata=10008000 ack=01
    const uint8_t res[] = {0x05,0x01, 0x01};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,TransferBlock_AP_DRW_R) {
    const uint8_t req[] = {0x06,0x00, 0x04,0x00, 0x0f};
    //SWD: AP_DRW R 10008000 request=0f(AP R c) wdata=ffffffff rdata=10008000 ack=01
    //SWD: AP_DRW R 0000000d request=0f(AP R c) wdata=00000006 rdata=0000000d ack=01
    //SWD: AP_DRW R 00000010 request=0f(AP R c) wdata=0000000d rdata=00000010 ack=01
    //SWD: AP_DRW R 00000005 request=0f(AP R c) wdata=00000010 rdata=00000005 ack=01
    //SWD: DP_RDBUFF 000000b1 request=0e(DP R c) wdata=00000005 rdata=000000b1 ack=01
    const uint8_t res[] = {0x06, 0x04,0x00, 0x01, 
        0x0d,0x00,0x00,0x00, 0x10,0x00,0x00,0x00, 0x05,0x00,0x00,0x00, 0xb1,0x00,0x00,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, 4) == 0);
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,SWJ_Pins_nRESET_OFF) {
    const uint8_t req[] = {0x10,0x00,0x80,0x00,0x00,0x00,0x00,};
    //DAP: SWJ_Pins wait: 0 us nRESET OFF
    const uint8_t res[] = {0x10,0x03};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,SWJ_Pins_nRESET_ON) {
    const uint8_t req[] = {0x10,0x80,0x80,0x00,0x00,0x00,0x00,};
    //DAP: SWJ_Pins wait: 0 us nRESET ON
    const uint8_t res[] = {0x10,0x83};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,SWJ_Pins) {
    const uint8_t req[] = {0x10,0x00,0x00,0x00,0x00,0x00,0x00,};
    //DAP: SWJ_Pins wait: 0 us nRESET ON
    const uint8_t res[] = {0x10,0x83};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Disconnect) {
    const uint8_t req[] = {0x03};
    const uint8_t res[] = {0x03,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,LED_DEBUGGER_CONNECTED_OFF) {
    const uint8_t req[] = {0x01,0x00,0x00};
    const uint8_t res[] = {0x01,0x00};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len == sizeof(res));
    ASSERT_TRUE(memcmp(recv, res, len) == 0);
}

TEST(DAP1,Vender0) {
    const uint8_t req[] = {0x80};
    const uint8_t res[] = {0x80,0x00, '1','0','4','0'};
    int len = dap->Command((uint8_t*)req, recv);
    ASSERT_TRUE(len >= sizeof(res));
    ASSERT_TRUE(recv[0] == 0x80);
    ASSERT_TRUE(memcmp(recv+2, res+2, 4) == 0); // 1040 lpc11u24
}

int main() {
    //pc.baud(921600);
    pc.baud(9600);
    DBG("%s", __FILE__);

    RUN_ALL_TESTS();
    exit(0);
}
#endif
