// test1_Target2.cpp 2013/9/14
#if 0
#include "Target2.h"
#include "mytest.h"

Serial pc(USBTX, USBRX);
#ifdef TARGET_LPC1768
Target2 target(p21,p22,p17); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
#endif
#ifdef TARGET_KL25Z
Target2 target(PTB8,PTB9,PTB10); // SWDIO(dp12),SWCLK(dp3),nReset(dp23)
#endif

TEST(Target2,setup) {
    ASSERT_TRUE(target.setup());
}

TEST(Target2,readMemory1) {
    uint32_t data = target.readMemory(0); // sp
    ASSERT_TRUE(data == 0x10001000);
}

TEST(Target2,readMemory2) {
    for(uint32_t addr = 0; addr < 0x1c; addr += 4) {
        uint32_t data = target.readMemory(addr);
        //TEST_PRINT("addr=%08x data=%08x\n", addr, data);
    }
}

TEST(Target2,readMemory3) {
    for(uint32_t addr = 0; addr < 0x100; addr += 4) {
        uint32_t data = target.readMemory(addr);
    }
}

TEST(Target2,DHCSR1) {
    uint32_t data = target.readMemory(0xE000EDF0);
    
}

TEST(Target2,getStatus1) {
    int status = target.getStatus();
    ASSERT_TRUE(status == TARGET_RUNNING);
}

TEST(Target2,halt1) {
    target.halt();
    int status = target.getStatus();
    ASSERT_TRUE(status == TARGET_HALTED);
}

TEST(Target2,resume1) {
    target.resume();
    int status = target.getStatus();
    ASSERT_TRUE(status == TARGET_RUNNING);
}

TEST(Target2,writeMemory1) {
    uint32_t addr = 0x10000000;
    target.halt();
    int status = target.getStatus();
    ASSERT_TRUE(status == TARGET_HALTED);

    uint32_t data = target.readMemory(addr);
    target.writeMemory(addr, 0x12345678);
    ASSERT_TRUE(target.readMemory(addr) == 0x12345678);
    target.writeMemory(addr, data);
    ASSERT_TRUE(target.readMemory(addr) == data);

    target.resume();
    status = target.getStatus();
    ASSERT_TRUE(status == TARGET_RUNNING);
}

TEST(Target2,writeMemory2) {
    uint32_t addr = 0x10001000-4;
    uint32_t data = target.readMemory(addr);
    target.writeMemory(addr, 0x12345678);
    ASSERT_TRUE(target.readMemory(addr) == 0x12345678);
    target.writeMemory(addr, data);
    ASSERT_TRUE(target.readMemory(addr) == data);
}

TEST(CoreReg,r0) {
    uint32_t r0 = target.r0.read();
}

TEST(CoreReg,r1) {
    target.halt();
    uint32_t backup = target.r1.read();
    target.r1.write(0x11223344);
    uint32_t data = target.r1.read();
    ASSERT_TRUE(data == 0x11223344);
    target.r1.write(backup);
    target.resume();
}

TEST(CoreReg,r2) {
    target.halt();
    uint32_t backup = target.r2;
    target.r2 = 0x11223344;
    ASSERT_TRUE(target.r2 == 0x11223344);
    target.r2 = backup;
    target.resume();
}

TEST(CoreReg,pc) {
    uint32_t pc = target.pc.read();
    //TEST_PRINT("pc=%08x\n", pc);
}

TEST(Target2,wait_status1) {
    target.halt();
    bool r = target.wait_status(TARGET_HALTED);
    ASSERT_TRUE(r);
    target.resume();
    r = target.wait_status(TARGET_HALTED, 50);
    ASSERT_TRUE(!r);
}

TEST(Target2,writeMemory3) {
    target.halt();
    bool r = target.wait_status(TARGET_HALTED);
    ASSERT_TRUE(r);

    uint8_t buf[256];
    for(int i = 0; i < sizeof(buf); i++) {
        buf[i] = i;
    }
    uint32_t addr = 0x10000000;
    target.writeMemory(addr, (uint32_t*)buf, sizeof(buf)/sizeof(uint32_t));

    uint8_t rbuf[256];
    target.readMemory(addr, (uint32_t*)rbuf, sizeof(rbuf)/sizeof(uint32_t));

    ASSERT_TRUE(memcmp(buf, rbuf, sizeof(buf)) == 0);
}

#define SYST_CSR 0xe000e010

#define ICER  0xe000e180
#define ICPR  0xe000e280

#define CPUID 0xe000ed00
#define ICSR  0xe000ed04

TEST(Target2,test_SCB) {
    target.resume();
    for(int i = 0; i < 3; i++) {
        uint32_t pc = target.pc.read();
        TEST_PRINT("pc=%08x", pc);

        uint32_t syst_csr = target.readMemory(SYST_CSR);
        TEST_PRINT("SYST_CSR=%08x", syst_csr);
        uint32_t icer = target.readMemory(ICER);
        TEST_PRINT("ICER=%08x", icer);
        uint32_t icpr = target.readMemory(ICPR);
        TEST_PRINT("ICPR=%08x", icpr);
        uint32_t cpuid = target.readMemory(CPUID);
        TEST_PRINT("CPUID=%08x", cpuid);
        uint32_t icsr = target.readMemory(ICSR);
        TEST_PRINT("ICSR=%08x", icsr);
    }
    for(int i = 0; i < 100; i++) {
        uint32_t syst_csr = target.readMemory(SYST_CSR);
        if (syst_csr != 0) {
            TEST_PRINT("SYST_CSR=%08x", syst_csr);
            break;
        }
    }
}

int main() {
    //pc.baud(921600);
    pc.baud(9600);
    DBG("%s", __FILE__);

    RUN_ALL_TESTS();
}
#endif

