// mydebug.h 2014/6/22
#pragma once

#define MY_DEBUG 1

#if MY_DEBUG
#include "mbed_debug.h"
extern void debug_hex(uint8_t* buf, int len);
#define DBG(x, ...) debug("[%s:%d]"x"\r\n", __PRETTY_FUNCTION__, __LINE__, ##__VA_ARGS__);
#define DBG_HEX(A,B) do{debug("[%s:%d]\r\n",__PRETTY_FUNCTION__, __LINE__);debug_hex(A,B);}while(0);
#else
#define DBG(x, ...) while(0)
#define DBG_HEX(A,B) while(0)
#endif

#if 1
extern void myassert(const char* func, int line, const char* expr); 
#define TEST_ASSERT(A) while(!(A)){myassert(__PRETTY_FUNCTION__, __LINE__, #A);}
#else
#define TEST_ASSERT(A) while(0)
#endif

#if 1
extern void mytrace(const char* func, int line);
extern void mytrace1(const char* func, int line, uint32_t value);
extern void mytrace_view();
#define TRACE() mytrace(__PRETTY_FUNCTION__, __LINE__)
#define TRACE1(A) mytrace1(__PRETTY_FUNCTION__, __LINE__, A)
#define TRACE_VIEW() mytrace_view()
#else
#define TRACE() while(0)
#define TRACE1(A) while(0)
#define TRACE_VIEW() while(0)
#endif
 
