// main.cpp 2014/6/22
#if 1
#include "Target2.h"
#include "Flash.h"
#include "USBLocalFileSystem.h"
#include "Semihost.h"
#include "mydebug.h"

#if defined(TARGET_KL46Z)
#define TARGET_SWDIO D12
#define TARGET_SWCLK D10
#define TARGET_nRESET D6
#define SW_PIN SW1
#define SW_MODE PullUp
#define LED_OFF 1

#elif defined(TARGET_LPC1549)
#define TARGET_SWDIO D12
#define TARGET_SWCLK D10
#define TARGET_nRESET D6
#define SW_PIN P1_9 // SW3
#define SW_MODE PullUp
#define LED_OFF 1

#elif defined(TARGET_LPC11U68)
#define TARGET_SWDIO D12
#define TARGET_SWCLK D10
#define TARGET_nRESET D6
#define SW_PIN P0_1 // SW2
#define SW_MODE PullUp
#define LED_OFF 1

#elif defined(TARGET_LPC1768)
#define TARGET_SWDIO p21
#define TARGET_SWCLK p22
#define TARGET_nRESET p30
#define SW_PIN p14 // joystick mbed application board
#define LED_OFF 0

#elif defined(TARGET_LPC4088)
#define TARGET_SWDIO p25
#define TARGET_SWCLK p26
#define TARGET_nRESET p34
#define SW_PIN p14 // joystick mbed application board
#define LED_OFF 0

#else
#error "target error"
#endif

Serial pc(USBTX,USBRX);
SWD swd(TARGET_SWDIO, TARGET_SWCLK, TARGET_nRESET);
InterruptIn sw(SW_PIN); 
DigitalOut led_flash(LED1);

void callback_flash() {
    led_flash = !led_flash;
}

__IO bool write_start = false;
void swIRQ() {
    wait_ms(100);
    write_start = true;
}

int main() {
    TRACE();
    pc.baud(9600);
    pc.printf("%s\n", __FILE__);
    led_flash = LED_OFF;

#ifdef SW_MODE
    sw.mode(SW_MODE);
#endif
    sw.rise(swIRQ);
        
    USBLocalFileSystem* usb_local = new USBLocalFileSystem(); // RamDisk(64KB)

    Target2* lpc = new Target2(&swd);
    if (!lpc->setup()) {
        pc.printf("*** SWD error.\n");
    }    
    Semihost semihost(lpc, &pc, usb_local);
    semihost.mount("/local");
    lpc->resume(); // C_DEBUGEN ON
    while(1) {
        if (write_start) {
            usb_local->lock(true);
            usb_local->remount();
            char filename[64];
            if (usb_local->find(filename, sizeof(filename), "*.BIN")) {
                pc.printf("*** bin filename=[%s]\n", filename);
                if (!lpc->setup()) {
                    pc.printf("*** SWD error.\n");
                } else {
                    Flash flash(lpc, &pc);
                    flash.attachEvent(callback_flash);
                    if (flash.init()) {
                        flash.write(filename);
                        flash.verify(filename);
                    }
                }
            } else {
                pc.printf("*** binary image file not found.\n");
            }
            usb_local->lock(false);
            lpc->SoftwareReset();    
            lpc->HardwareReset();
            led_flash = LED_OFF;
            write_start = false;
        }
        semihost.poll();
    }        
}
#endif

