#include "mbed.h"

DigitalOut led1(P0_1);

#define SYS_WRITEC 0x03

int semihost_putc(int c)
{
    // LPC810 cannot access core debug register by self.
    return __semihost(SYS_WRITEC, &c);
}
// semihosting client
int main() {
    const char* msg = "Hello from LPC810.";
    while(1) {
        for(const char* p = msg; *p; p++) {
            semihost_putc(*p);
            led1 = !led1;
            wait_ms(200);
        }           
    }
}
