#ifdef TARGET_LPC812
#include "mbed.h"
#include "SCT_PWM.h"
#include "MRT.h"

SCT_PWM r (LED_RED, 0);
SCT_PWM g (LED_GREEN, 1);
SCT_PWM b (LED_BLUE, 2);

int main()
{
    MRT* mrt = new MRT();
    r.period(0.001);
    while(1) {
        for(float i = 0.0; i < 1.0 ; i += 0.001) {
            float p = 3 * i;
            r = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
            g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
            b = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;  
            mrt->wait_ms(10);
        }
    }
}

#else
// http://mbed.org/users/chris/code/app-board-RGB/
#include "mbed.h"

PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

int main()
{
    r.period(0.001);
    while(1) {
        for(float i = 0.0; i < 1.0 ; i += 0.001) {
            float p = 3 * i;
            r = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
            g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
            b = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;  
            wait (0.01);
        }
    }
}
#endif
