#pragma once
#include "LPC8xx.h"

class SCT_PWM {
public:
    SCT_PWM(int pin = 7, int channel = 0);
    void period(float seconds);
    void period_ms(int ms);
    void period_us(int us);
    void pulsewidth(float seconds);
    void pulsewidth_ms(int ms);
    void pulsewidth_us(int us);
    void write(float value);
    float read();
    void swm(int pin = 7);

    SCT_PWM& operator= (float value) {
        write(value);
        return *this;
    }

    SCT_PWM& operator= (SCT_PWM& rhs) {
        write(rhs.read());
        return *this;
    }

protected:
    void inst();
    int ch;
};
