#pragma once
#include "LPC8xx.h"

class MRT {
public:
    MRT(int channel = 0);
    /** write down counter
     * @param interval start count
     */
    void write(uint32_t interval);
    /** read down counter
     */
    uint32_t read();
    enum STAT {
        IDLE,
        RUNNING,
    };
    int status();
    void wait_ms(uint32_t timeout_ms);
    void wait_us(uint32_t timeout_us);
    void wait_raw(uint32_t timeout);
protected:
    void inst();
    MRT_Channel_cfg_Type* _ch;
    int us_clk;
};
