#include "MRT.h"

MRT::MRT(int channel)
{
    static bool insted = false;

    if (!insted) {
        inst();
        insted = true;
    }

    _ch = &LPC_MRT->Channel[channel];
    _ch->CTRL |= (1<<1); // one-shot
}

void MRT::inst()
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<10); // enable MRT
    LPC_SYSCON->PRESETCTRL |= (1<<7); // reset MRT
    us_clk = SystemCoreClock / 1000000;
}

void MRT::write(uint32_t interval)
{
    _ch->INTVAL = interval | (1<<31); // and LOAD
    _ch->STAT |= 0x01;
}

int MRT::status()
{
    return (_ch->STAT & 1) ? IDLE : RUNNING;
}

void MRT::wait_ms(uint32_t timeout_ms)
{
    wait_raw(us_clk * 1000 * timeout_ms);
}

void MRT::wait_us(uint32_t timeout_us)
{
    wait_raw(us_clk * timeout_us);
}

void MRT::wait_raw(uint32_t timeout)
{
    write(timeout);
    while(status() == RUNNING);
}

uint32_t MRT::read()
{
     return _ch->TIMER;
}
