#include <rl_usb.h>
#include <LPC15xx.h>

/*
 *  USB Device Initialize Function
 *   Called by the User to initialize USB Device
 *    Return Value:    None
 */

void USBD_Init (void)
{
	/* Set USB PLL input to main oscillator */
    LPC_SYSCON->USBPLLCLKSEL = 0x01;
    /* Setup USB PLL  (FCLKIN = 12MHz) * 4 = 48MHz
	   MSEL = 3 (this is pre-decremented), PSEL = 1 (for P = 2)
	   FCLKOUT = FCLKIN * (MSEL + 1) = 12MHz * 4 = 48MHz
	   FCCO = FCLKOUT * 2 * P = 48MHz * 2 * 2 = 192MHz (within FCCO range) */
    LPC_SYSCON->USBPLLCTRL = 3|(1<<6);

	/* Powerup USB PLL */  
    LPC_SYSCON->PDRUNCFG &= ~(1<<23);

    /* Wait for PLL to lock */
    while(!(LPC_SYSCON->USBPLLSTAT&0x01));

    /* enable USB main clock */
    LPC_SYSCON->USBCLKSEL = 0x02;
    LPC_SYSCON->USBCLKDIV = 1;
    /* Enable AHB clock to the USB block. */
    LPC_SYSCON->SYSAHBCLKCTRL1 |= (1<<23);
    /* power UP USB Phy */
    LPC_SYSCON->PDRUNCFG &= ~(1<<9);
    /* Reset USB block */
    LPC_SYSCON->PRESETCTRL1 |= (1<23);
}

/*
 *  USB Device Connect Function
 *   Called by the User to Connect/Disconnect USB Device
 *    Parameters:      con:   Connect/Disconnect
 *    Return Value:    None
 */

void USBD_Connect(uint8_t con)
{
    if (con) {
        NVIC_EnableIRQ(USB_IRQ_IRQn);
    } else {
        NVIC_DisableIRQ(USB_IRQ_IRQn);
    }
}

/*
 *  USB Device Interrupt Service Routine
 */

void USB_IRQ_IRQHandler(void) {
  pUsbApi->hw->ISR(hUsb);
}
