#ifndef _USB_H_
#define _USB_H_

typedef enum {
    LPC_OK=0,
} ErrorCode_t;

typedef uint32_t USBD_HANDLE_T;
typedef void* USB_CB_T;
typedef void* USB_PARAM_CB_T;

typedef struct _USB_CORE_DESCS_T {
    const uint8_t *device_desc;
    const uint8_t *string_desc;
    const uint8_t *full_speed_desc;
    const uint8_t *high_speed_desc;
    const uint8_t *device_qualifier;
} USB_CORE_DESCS_T;

typedef struct USBD_API_INIT_PARAM {
    uint32_t usb_reg_base; 
    uint8_t* mem_base;
    uint32_t mem_size;
    uint8_t max_num_ep;
    uint8_t pad0[3];
    USB_CB_T USB_Reset_Event;
    USB_CB_T USB_Suspend_Event;
    USB_CB_T USB_Resume_Event;
    USB_CB_T reserved_sbz;
    USB_CB_T USB_SOF_Event;
    USB_PARAM_CB_T USB_WakeUpCfg;
    USB_PARAM_CB_T USB_Power_Event;
    USB_PARAM_CB_T USB_Error_Event;
    USB_CB_T USB_Configure_Event;
    USB_CB_T USB_Interface_Event;
    USB_CB_T USB_Feature_Event;
    uint32_t (* virt_to_phys)(void* vaddr);
    void (* cache_flush)(uint32_t* start_adr, uint32_t* end_adr);
} USBD_API_INIT_PARAM_T;

typedef struct USBD_HW_API {
    uint32_t (*GetMemSize)(USBD_API_INIT_PARAM_T* param);
    ErrorCode_t (*Init)(USBD_HANDLE_T* phUsb, USB_CORE_DESCS_T* pDesc, USBD_API_INIT_PARAM_T* param);
    void (*Connect)(USBD_HANDLE_T hUsb, uint32_t con);
    void (*ISR)(USBD_HANDLE_T hUsb);
} USBD_HW_API_T;

typedef struct USBD_CORE_API {
    void* dummy;
    //TODO
} USBD_CORE_API_T;

typedef struct USBD_MSC_INIT_PARAM {
    uint8_t* mem_base;
    uint32_t mem_size;
    const uint8_t* InquiryStr;
    uint32_t BlockCount;
    uint32_t BlockSize;
    uint32_t MemorySize;
    const uint8_t* intf_desc;
    void (*MSC_Write)(uint32_t offset, uint8_t** src, uint32_t length, uint32_t high_offset);
    void (*MSC_Read)(uint32_t offset, uint8_t** dst, uint32_t length, uint32_t high_offset);
    ErrorCode_t (*MSC_Verify)(uint32_t offset, uint8_t buf[], uint32_t length, uint32_t high_offset);
    void (*MSC_GetWriteBuf)(uint32_t offset, uint8_t** buff_adr, uint32_t length, uint32_t high_offset);
    ErrorCode_t (*MSC_Ep0_Hdlr)(USBD_HANDLE_T hUsb, void* data, uint32_t event);
    uint64_t  MemorySize64;
} USBD_MSC_INIT_PARAM_T;

typedef struct USBD_MSC_API {
    uint32_t (*GetMemSize)(USBD_MSC_INIT_PARAM_T* param);
    ErrorCode_t (*init)(USBD_HANDLE_T hUsb, USBD_MSC_INIT_PARAM_T* param);
} USBD_MSC_API_T;

typedef struct USBD_HID_API {
    void* dummy;
    // TODO
} USBD_HID_API_T;
typedef struct USBD_CDC_API {
    void* dummy;
    // TODO
} USBD_CDC_API_T;

typedef struct USBD_API {
  const USBD_HW_API_T* hw;
  const USBD_CORE_API_T* core;
  const USBD_MSC_API_T* msc;
  const void* dfu;
  const USBD_HID_API_T* hid;
  const USBD_CDC_API_T* cdc;
  const uint32_t* reserved6;
  uint32_t version;
} USBD_API_T;

typedef struct _ROM {
   const USBD_API_T * pUSBD;
} ROM;

extern USBD_API_T* pUsbApi;
extern USBD_HANDLE_T hUsb;

extern uint32_t USBD_MSC_MemorySize;
extern uint32_t USBD_MSC_BlockSize;
extern uint32_t USBD_MSC_BlockGroup;
extern uint32_t USBD_MSC_BlockCount;
extern uint8_t* USBD_MSC_BlockBuf;
extern uint8_t USBD_MSC_MediaReady;

#endif // _USB_H_
