// app-board-websocket-rpc/main.cpp
#include "EthernetInterface.h"
#include "Websocket.h"
#include "mbed_rpc.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include "MMA7660.h"
#include <string>

#define CHANNEL "appboard-rpc"
#define URL "ws://sockets.mbed.org/ws/"CHANNEL"/rw"
#define VIEWER "http://va009039-mbed.appspot.com/appboard/"CHANNEL

Serial pc(USBTX, USBRX);
C12832_LCD lcd;
LM75B LM75B_tmp(p28, p27);
MMA7660 MMA(p28, p27);
 
int main() {
    pc.baud(921600);
    printf("%s\n", __FILE__);

    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\n\r", eth.getIPAddress());
 
    Websocket ws(URL);
    ws.connect();

    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::add_rpc_class<RpcDigitalIn>();
    RPC::add_rpc_class<RpcDigitalInOut>();
    RPC::add_rpc_class<RpcAnalogIn>();
    RPC::add_rpc_class<RpcAnalogOut>();
    RPC::add_rpc_class<RpcPwmOut>();
    RPC::add_rpc_class<RpcSPI>();
    RPC::add_rpc_class<RpcSerial>();
    RPC::add_rpc_class<RpcTimer>();

    RPC::construct<RpcDigitalOut, PinName, const char*>(LED1, "led1"); // mbed LED  
    RPC::construct<RpcDigitalOut, PinName, const char*>(LED2, "led2");  
    RPC::construct<RpcDigitalOut, PinName, const char*>(LED3, "led3");  
    RPC::construct<RpcDigitalOut, PinName, const char*>(LED4, "led4");  

    RPC::construct<RpcDigitalIn, PinName, const char*>(p12, "Down"); // Joystick  
    RPC::construct<RpcDigitalIn, PinName, const char*>(p13, "Left");
    RPC::construct<RpcDigitalIn, PinName, const char*>(p14, "Centre");
    RPC::construct<RpcDigitalIn, PinName, const char*>(p15, "Up");
    RPC::construct<RpcDigitalIn, PinName, const char*>(p16, "Right");

    RPC::construct<RpcAnalogIn, PinName, const char*>(p19, "pot1");  // Potentiometers left
    RPC::construct<RpcAnalogIn, PinName, const char*>(p20, "pot2");  // right

    RPC::construct<RpcPwmOut, PinName, const char*>(p23, "Red"); // RGB LED 
    RPC::construct<RpcPwmOut, PinName, const char*>(p24, "Green"); 
    RPC::construct<RpcPwmOut, PinName, const char*>(p25, "Blue"); 

    pc.printf("\n\n"VIEWER"\n\n");

    Timer t,MMA_t;
    t.reset();
    t.start();
    MMA_t.reset();
    MMA_t.start();
    float pre_x,pre_y,pre_z;
    float pre_pot[2] = {0.0, 0.0};
    const char* pot_name[] = {"pot1", "pot2", NULL};
    char buf[RPC_MAX_STRING], result[RPC_MAX_STRING];
    while(1) {
        if (ws.read(buf)) {
            pc.printf("ws.read: %s\n", buf);
            lcd.locate(0, 0);
            lcd.printf("rcv: %s", buf);
            if (buf[0] == '/') {
                RPC::call(buf, result); 
                pc.printf("result: %s\n", result);
                ws.send(result);
            }
            t.reset();
        }
        
        for(int i = 0; pot_name[i] != NULL; i++) {
            RPC* rpc = RPC::lookup(pot_name[i]);
            if (rpc) {
                float pot = reinterpret_cast<RpcAnalogIn*>(rpc)->read();
                if (abs(pre_pot[i] - pot) > 0.05) {
                    pre_pot[i] = pot;
                    snprintf(buf, sizeof(buf), "{\"%s\":%.2f}", pot_name[i], pot);
                    pc.printf("ws.send: %s\n", buf);
                    lcd.locate(0, 16);
                    lcd.printf("snd: %s", buf);
                    ws.send(buf);
                    t.reset();
                }
            }
        }
        if (t.read() > 60) {
            snprintf(buf, sizeof(buf), "{\"LM75B\":%.2f}", LM75B_tmp.read());
            pc.printf("ws.send: %s\n", buf);
            ws.send(buf);
            t.reset();
        }
        if (MMA_t.read_ms() > 100) {
            MMA_t.reset();
            float x = MMA.x();
            float y = MMA.y();
            float z = MMA.z();
            if (abs(pre_x - x) > 0.1 || abs(pre_y - y) > 0.1 || abs(pre_z - z) > 0.1) {
                pre_x = x; pre_y = y; pre_z = z;
                snprintf(buf, sizeof(buf), "{\"MMA7660\":{\"x\":%.2f,\"y\":%.2f,\"z\":%.2f}}", x, y, z);
                lcd.locate(0, 0);
                lcd.printf(buf);
                pc.printf("ws.send: %s\n", buf);
            }
        }
        //Thread::wait(100);
    }
}
